% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secret.R
\name{gargle_secret}
\alias{gargle_secret}
\alias{secret_encrypt_json}
\alias{secret_decrypt_json}
\alias{secret_make_key}
\alias{secret_write_rds}
\alias{secret_read_rds}
\alias{secret_has_key}
\title{Encrypt/decrypt JSON or an R object}
\usage{
secret_encrypt_json(json, path = NULL, key)

secret_decrypt_json(path, key)

secret_make_key()

secret_write_rds(x, path, key)

secret_read_rds(path, key)

secret_has_key(key)
}
\arguments{
\item{json}{A JSON file (or string).}

\item{path}{The path to write to (\code{secret_encrypt_json()},
\code{secret_write_rds()}) or to read from (\code{secret_decrypt_json()},
\code{secret_read_rds()}).}

\item{key}{Encryption key, as implemented by httr2's \href{https://httr2.r-lib.org/reference/secrets.html}{secret functions}. This should
almost always be the name of an environment variable whose value was
generated with \code{secret_make_key()} (which is an inlined copy of
\code{httr2::secret_make_key()}).}

\item{x}{An R object.}
}
\value{
\itemize{
\item \code{secret_encrypt_json()}: The encrypted JSON string, invisibly. In typical
use, this function is mainly called for its side effect, which is to write an
encrypted file.
\item \code{secret_decrypt_json()}: The decrypted JSON string, invisibly.
\item \code{secret_write_rds()}: \code{x}, invisibly
\item \code{secret_read_rds()}: the decrypted object.
\item \code{secret_make_key()}: a random string to use as an encryption key.
\item \code{secret_has_key()} returns \code{TRUE} if the key is available and \code{FALSE}
otherwise.
}
}
\description{
These functions help to encrypt and decrypt confidential information that you
might need when deploying gargle-using projects or in CI/CD. They basically
rely on inlined copies of the \href{https://httr2.r-lib.org/reference/secrets.html}{secret functions in the httr2 package}. The awkwardness of
inlining code from httr2 can be removed if/when gargle starts to depend on
httr2.
\itemize{
\item The \code{secret_encrypt_json()} + \code{secret_decrypt_json()} pair is unique to
gargle, given how frequently Google auth relies on JSON files, e.g., service
account tokens and OAuth clients.
\item The \code{secret_write_rds()} + \code{secret_read_rds()} pair is just a copy of
functions from httr2. They are handy if you need to secure a user token.
\item \code{secret_make_key()} and \code{secret_has_key()} are also copies of functions
from httr2. Use \code{secret_make_key} to generate a key. Use \code{secret_has_key()}
to condition on key availability in, e.g., examples, tests, or apps.
}
}
\examples{
\dontshow{if (secret_has_key("GARGLE_KEY")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# gargle ships with JSON for a fake service account
# here we put the encrypted JSON into a new file
tmp <- tempfile()
secret_encrypt_json(
  fs::path_package("gargle", "extdata", "fake_service_account.json"),
  tmp,
  key = "GARGLE_KEY"
)

# complete the round trip by providing the decrypted JSON to a credential
# function
credentials_service_account(
 scopes = "https://www.googleapis.com/auth/userinfo.email",
 path = secret_decrypt_json(
   fs::path_package("gargle", "secret", "gargle-testing.json"),
   key = "GARGLE_KEY"
 )
)

file.remove(tmp)

# make an artificial Gargle2.0 token
fauxen <- gargle2.0_token(
  email = "jane@example.org",
  client = gargle_oauth_client(
    id = "CLIENT_ID", secret = "SECRET", name = "CLIENT"
  ),
  credentials = list(token = "fauxen"),
  cache = FALSE
)
fauxen

# store the fake token in an encrypted file
tmp2 <- tempfile()
secret_write_rds(fauxen, path = tmp2, key = "GARGLE_KEY")

# complete the round trip by providing the decrypted token to the "BYO token"
# credential function
rt_fauxen <- credentials_byo_oauth2(
  token  = secret_read_rds(tmp2, key = "GARGLE_KEY")
)
rt_fauxen

file.remove(tmp2)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
