% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GVN.R
\name{GVN}
\alias{GVN}
\title{Graph Von Neumann Estimator.}
\usage{
GVN(y, A, L)
}
\arguments{
\item{y}{Noisy data.}

\item{A}{Adjacency matrix.}

\item{L}{Laplacian matrix.}
}
\description{
Graph equivalent of the Von Neummann variance estimator.
}
\examples{
data(minnesota)
A <- minnesota$A
L <- laplacian_mat(A)
x <- minnesota$xy[ ,1]
n <- length(x)
f <- sin(x)
sigma <- 0.1
noise <- rnorm(n, sd = sigma)
y <- f + noise
sigma^2
GVN(y, A, L)
}
\references{
von Neumann, J. (1941). Distribution of the ratio of the mean square successive difference to the variance. \emph{Ann. Math. Statistics}, 35(3), 433--451.

de Loynes, B., Navarro, F., Olivier, B. (2021). Data-driven thresholding in denoising with Spectral Graph Wavelet Transform. Journal of Computational and Applied Mathematics, Vol. 389.
}
\seealso{
\code{\link{HPFVN}}
}
