% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fstepstepwise.R
\name{fstepstepwise}
\alias{fstepstepwise}
\title{Repeated stepwise selection of covariates}
\usage{
fstepstepwise(y, x, alpha, nu = 1, kmax = 0, kexk = 0,
  lmax = 10^10, intercept = TRUE, chkintercept = FALSE,
  misclass = FALSE)
}
\arguments{
\item{y}{Dependent variable}

\item{x}{Covariates}

\item{alpha}{The P-value cut-off}

\item{nu}{The order statistic of Gaussian covariates used for comparison}

\item{kmax}{The maximum number of included covariates}

\item{kexk}{The excluded covariates}

\item{lmax}{The maximum number of linear approximations}

\item{intercept}{Logical to include intercept}

\item{chkintercept}{Logical to include or exclude intercept dependent on the P-value}

\item{misclass}{Logical giving the number of misclassifications if appropriate,  eg for binary y}

}
\value{
pv In order, the number of linear approximation, the included covariates, the P-values, sum of squared residuals and if appropriate number of misclassifications.
}
\description{
Repeated stepwise selection of covariates
}
\examples{
data(gausscov)
fstepstepwise(ly.original,lx.original,0.01,lmax=10,misclass=TRUE)
}
