% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgr1st.R
\name{fgr1st}
\alias{fgr1st}
\title{Calculates an independence graph using stepwise selection}
\usage{
fgr1st(x,p0=0.01,km=0,kmx=0,nu=1,nedge=10^6,inr=T,dr=F)
}
\arguments{
\item{x}{The variables}

\item{p0}{Cut-off p-value}

\item{km}{Maximum number selected variables for each node irrespective of cut-off P-value}

\item{kmx}{The maximum number of selected covariates for each node for given cut-off P-value}

\item{nu}{Order statistic}

\item{nedge}{Maximum number of edges}

\item{inr}{Logical, if TRUE include an intercept}

\item{dr}{Logical, if TRUE (a,b) and (b,a), a not equal b,  are different edges}

}
\value{
ned Number of edges

edg The edges for each node in the graph
}
\description{
Calculates an independence graph using stepwise selection
}
\examples{
data(boston)
a<-fgr1st(boston[,1:13])
}
