% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmch.R
\name{fmch}
\alias{fmch}
\title{Calculates all subsets  where each included covariate is significant.}

\usage{
fmch(y,x,p0=0.01,q=-1,ind=0,sel=T,inr=T,xinr=F)
}
\arguments{
\item{y}{The dependent variable}

\item{x}{The covariates}

\item{p0}{Cut-off p-value for significance}

\item{q}{The number of covarites from which to choose}

\item{ind}{Indices of subset for which all subsets are to be considered}

\item{sel}{If TRUE calls fselect to removes all subsets of chosen sets}

\item{inr}{If TRUE to include intercept}

\item{xinr}{If TRUE intercept already included}
}
\value{
nv List of subsets with number of covariates and sum of squared residuals
}
\description{
It sel =TRUE it calls fselect and  removes all such subsets which are a subset of some other selected subset. The remaining ones are ordered according to the sum of squared residuals. Subsets must be decoded with decode, NOT decode1.
}
\examples{
data(redwine)
nvv<-fmch(redwine[,12],redwine[,1:11])
}
