% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frasb.R
\name{frasb}
\alias{frasb}
\title{Robust selection of covariates using Huber's psi-function or Hampel's redescending psi-function  based on all subsets}
\usage{
frasb(y,x,cn=1,cnr=c(1,3,5),p0=0.01,q=-1,sg=0,ind=0,sel=T,inr=T,xinr=F,red=F)
}
\arguments{
\item{y}{The dependent variable}

\item{x}{The covariates}

\item{cn}{The constant  for Huber's psi-function}

\item{cnr}{The constants for for Hampel's three part redescending  psi-function}

\item{p0}{The P-value cut-off}

\item{q}{If q>0   the number of covariates from which ind was chosen}

\item{sg}{The scale parameter}

\item{ind}{The subset for which the results are required}

\item{sel}{Logical, if TRUE removes all subsets of chosen sets}

\item{inr}{Logical if TRUE include intercept}

\item{xinr}{ Logical If TRUE intercept included in x}

\item{red}{Logical If true Hampel's three part redescending psi function}
}
\value{
nv  Coded list of subsets with number of covariates and scale ordered according to scale.
}
\description{
Calculates all possible subsets and selects those where each included covariate is significant using a robustified version of fasb.R 
}
\examples{
data(boston)
a<-frasb(boston[,14],boston[,1:8])
ind<-decode(235,8)
}
