% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_gaussian_2D.R
\name{ggplot_gaussian_2D}
\alias{ggplot_gaussian_2D}
\title{Plot a 2D gaussian via ggplot}
\usage{
ggplot_gaussian_2D(
  gauss_data,
  normalize = TRUE,
  contour_thickness = 0.04,
  bins = 15,
  viridis_dir = 1,
  viridis_opt = "B",
  x_lab = "X values",
  y_lab = "Y values",
  axis.text = element_text(size = 6),
  axis.title = element_text(size = 7),
  axis.ticks = element_line(size = 0.3),
  plot.margin = unit(c(0.1, 0.1, 0.1, 0.1), "cm")
)
}
\arguments{
\item{gauss_data}{Data.frame with X_values, Y_values, and predicted_values,
e.g. exported from \code{predict_gaussian_2D()}}

\item{normalize}{Default TRUE, should predicted_values be normalized on a 0
to 1 scale?}

\item{contour_thickness}{Thickness of contour lines}

\item{bins}{Number of bins for the contour plot}

\item{viridis_dir}{See "direction" in scale_fill_viridis_c()}

\item{viridis_opt}{See "option" in scale_fill_viridis_c()}

\item{x_lab}{Arguments passed to xlab()}

\item{y_lab}{Arguments passed to ylab()}

\item{axis.text}{Arguments passed to axis.text}

\item{axis.title}{Arguments passed to axis.title}

\item{axis.ticks}{Arguments passed to axis.ticks}

\item{plot.margin}{Arguments passed to plot.margin}
}
\value{
A ggplot object that uses metR::geom_contour_fill() to display the
2D gaussian
}
\description{
Plot a 2D gaussian via ggplot
}
\examples{
if (interactive()) {
  ## Load the sample data set
  data(gaussplot_sample_data)

  ## Generate a grid of x- and y- values on which to predict
  grid <-
    expand.grid(X_values = seq(from = -5, to = 0, by = 0.1),
                Y_values = seq(from = -1, to = 4, by = 0.1))

  ## Predict the values using predict_gaussian_2D
  gauss_data <-
    predict_gaussian_2D(
      X_values = grid$X_values,
      Y_values = grid$Y_values,
      A = gaussplot_sample_data$A[1],
      X_peak = gaussplot_sample_data$X_peak[1],
      Y_peak = gaussplot_sample_data$Y_peak[1],
      Q = gaussplot_sample_data$Q[1],
      X_var = gaussplot_sample_data$X_var[1],
      Y_var = gaussplot_sample_data$Y_var[1]
    )

  ## Plot via ggplot2 and metR
  library(ggplot2); library(metR)
  ggplot_gaussian_2D(gauss_data)
 }
}
\author{
Vikram B. Baliga
}
