% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbif_download.R
\name{gbif_download}
\alias{gbif_download}
\title{Download GBIF data using aws.s3 sync}
\usage{
gbif_download(
  version = gbif_version(),
  dir = gbif_dir(),
  bucket = gbif_default_bucket(),
  region = ""
)
}
\arguments{
\item{version}{Release date (YYYY-MM-DD) which should be synced. Will
detect latest version by default.}

\item{dir}{path to local directory where parquet files should be stored.
Fine to leave at default, see \code{\link[=gbif_dir]{gbif_dir()}}.}

\item{bucket}{Name of the regional S3 bucket desired.
Default is "gbif-open-data-us-east-1". Select a bucket closer to your
compute location for improved performance, e.g. European researchers may
prefer "gbif-open-data-eu-central-1" etc.}

\item{region}{bucket region (usually ignored? Just set the bucket appropriately)}
}
\value{
logical indicating success or failure.
}
\description{
Sync a local directory with selected release of the AWS copy of GBIF
}
\details{
Sync parquet files from GBIF public data catalog,
https://registry.opendata.aws/gbif/.

Note that data can also be found on the Microsoft Cloud,
https://planetarycomputer.microsoft.com/dataset/gbif

Also, some users may prefer to download this data using an alternative
interface or work on a cloud-host machine where data is already available.
Note, these data include all CC0 and CC-BY licensed data in GBIF that have
coordinates which passed automated quality checks,
see \url{https://github.com/gbif/occurrence/blob/master/aws-public-data.md}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
gbif_download()
\dontshow{\}) # examplesIf}
}
