% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ogrlineref.R
\name{ogrlineref}
\alias{ogrlineref}
\title{ogrlineref}
\usage{
ogrlineref(help_general, progress, quiet, f, dsco, lco, create, l, ln, lf, p,
  pn, pm, pf, r, rn, o, on, of, s, get_pos, x, y, get_coord, m, get_subline, mb,
  me, ignore.full_scan = TRUE, verbose = FALSE)
}
\arguments{
\item{help_general}{Logical. Show the usage.}

\item{progress}{Logical. Show progress.}

\item{quiet}{Logical. Suppress all messages except errors and results.}

\item{f}{Character. format_name. Select an output format name. The default is to create a shapefile.}

\item{dsco}{Character. "NAME=VALUE". Dataset creation option (format specific).}

\item{lco}{Character. "NAME=VALUE". Layer creation option (format specific).}

\item{create}{Logical. Create the linear reference file (linestring of parts).}

\item{l}{Character. src_line_datasource_name. The path to input linestring datasource (e.g. the road)}

\item{ln}{Character. layer_name. The layer name in datasource}

\item{lf}{Character. field_name. The field name of uniq values to separate the input lines (e.g. the set of roads)}

\item{p}{Character. src_repers_datasource_name. The path to linear references points (e.g. the road mile-stones)}

\item{pn}{Character. layer_name. The layer name in datasource.}

\item{pm}{Character. pos_field_name.The field name of distances along path (e.g. mile-stones values)}

\item{pf}{Character. field_name. The field name of uniq values to map input reference points to lines}

\item{r}{Character. src_parts_datasource_name. The path to linear reference file}

\item{rn}{Character. layer_name. The layer name in datasource.}

\item{o}{Character. dst_datasource_name. The path to output linear reference file (linestring datasource)}

\item{on}{Character. layer_name. The layer name in datasource.}

\item{of}{Character. field_name. The field name for storing the uniq values of input lines}

\item{s}{Numeric. step. The part size in linear units.}

\item{get_pos}{Logical. Return linear referenced postion for input X, Y}

\item{x}{Numeric. long. Input X coordinate}

\item{y}{Numeric. lat. Input Y coordinate}

\item{get_coord}{Logical. Return point on path for input linear distance.}

\item{m}{Numeric. position. The input linear distance}

\item{get_subline}{Logical. Return the portion of the input path from and to input linear positions}

\item{mb}{Numeric. position. The input begin linear distance.}

\item{me}{Numeric. position. The input end linear distance}

\item{ignore.full_scan}{Logical. If FALSE, perform a brute-force scan if other installs are not found.  Default is TRUE.}

\item{verbose}{Logical. Enable verbose execution? Default is FALSE.}
}
\description{
R wrapper for ogrlineref: create a linear reference
}
\details{
This is an R wrapper for the 'ogrlineref' function that is part of the
Geospatial Data Abstraction Library (GDAL).  It follows the parameter naming
conventions of the original function, with some modifications to allow for more R-like
parameters.  For all parameters, the user can use a single character string following,
precisely, the gdalinfo format (\url{http://gdal.org/ogrlineref.html}), or,
in some cases, can use R vectors to achieve the same end.

The utility can be used for:
\itemize{
\item{create linear reference file from input data}
\item{return the "linear referenced" distance for the projection of the input coordinates (point) on the path}
\item{return the coordinates (point) on the path according to the "linear referenced" distance}
\item{return the portion of the path according to the "linear referenced" begin and end distances}
}
The ogrlineref program can be used to create a linear reference - a file containing
a segments of special length (e.g. 1 km in reference units) and get coordinates,
linear referenced distances or sublines (subpaths) from this file. The utility not
required the M or Z values in geometry. The results can be stored in any OGR supported
format. Also some information writed to the stdout.

This function assumes the user has a working GDAL on their system.  If the
"gdalUtils_gdalPath" option has been set (usually by gdal_setInstallation),
the GDAL found in that path will be used.  If nothing is found, gdal_setInstallation
will be executed to attempt to find a working GDAL.
}
\examples{
# No examples ATM for this function.
}
\author{
Jonathan A. Greenberg (\email{gdalUtils@estarcion.net}) (wrapper) and Frank Warmerdam (GDAL lead developer).
}
\references{
\url{http://www.gdal.org/ogrlineref.html}
}

