% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdalcubes.R
\docType{package}
\name{gdalcubes}
\alias{gdalcubes}
\alias{gdalcubes-package}
\title{gdalcubes: Earth Observation Data Cubes from Satellite Image Collections}
\description{
Processing collections of Earth observation images as on-demand multispectral, multitemporal data cubes. Users
define cubes by spatiotemporal extent, resolution, and spatial reference system and let 'gdalcubes' automatically apply cropping, reprojection, and 
resampling using the 'Geospatial Data Abstraction Library' ('GDAL'). Implemented functions on data cubes include reduction over space and time, applying arithmetic expressions on pixel band values,
moving window aggregates over time, filtering by space, time, bands, and predicates on pixel values, materializing data cubes as 'netCDF' files,
and plotting. User-defined 'R' functions can be applied over chunks of data cubes. The package implements lazy evaluation and 
multithreading. All computational parts are implemented in C++, linking to the 'GDAL', 'netCDF', 'CURL', and 'SQLite' libraries.
}
