% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube.R
\name{pack_minmax}
\alias{pack_minmax}
\title{Helper function to define packed data exports by min / max values}
\usage{
pack_minmax(type = "int16", min, max, simplify = FALSE)
}
\arguments{
\item{type}{target data type of packed values (one of "uint8", "uint16", "uint32", "int16", or "int32")}

\item{min}{numeric; minimum value(s) of original values, will be packed to the 2nd lowest value of the target data type}

\item{max}{numeric; maximum value(s) in original scale, will be packed to the highest value of the target data type}

\item{simplify}{logical; round resulting scale and offset to power of 10 values}
}
\description{
This function can be used to define packed exports in \code{\link{write_ncdf}}
and \code{\link{write_tif}}. It will generate scale and offset values with maximum precision (unless simplify=TRUE).
}
\details{
Nodata values will be mapped to the lowest value of the target data type.

Arguments min and max must have length 1 or length equal to the number of bands of the data cube to be exported. In the former
case, the same values are used for all bands of the exported target cube, whereas the latter case allows to use different 
ranges for different bands.
}
\note{
Using simplify=TRUE will round scale values to the next smaller power of 10.
}
\examples{
ndvi_packing = pack_minmax(type="int16", min=-1, max=1)
ndvi_packing

}
