% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdal_helpers.R
\name{vsi_get_fs_options}
\alias{vsi_get_fs_options}
\title{Return the list of options associated with a virtual file system handler}
\usage{
vsi_get_fs_options(filename, as_list = TRUE)
}
\arguments{
\item{filename}{Filename, or prefix of a virtual file system handler.}

\item{as_list}{Logical scalar. If \code{TRUE} (the default), the XML string
returned by GDAL will be coerced to list. \code{FALSE} to return the configuration
options as a serialized XML string.}
}
\value{
An XML string, or empty string (\code{""}) if no options are declared.
If \code{as_list = TRUE} (the default), the XML string will be coerced to list
with \code{xml2::as_list()}.
}
\description{
\code{vsi_get_fs_options()} returns the list of options associated with a virtual
file system handler. Those options may be set as configuration options with
\code{set_config_option()}.
Wrapper for \code{VSIGetFileSystemOptions()} in the GDAL API.
}
\examples{
vsi_get_fs_options("/vsimem/")

vsi_get_fs_options("/vsizip/")

vsi_get_fs_options("/vsizip/", as_list = FALSE)
}
\seealso{
\code{\link[=set_config_option]{set_config_option()}}, \code{\link[=vsi_get_fs_prefixes]{vsi_get_fs_prefixes()}}

\url{https://gdal.org/en/stable/user/virtual_file_systems.html}
}
