% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{validateCreationOptions}
\alias{validateCreationOptions}
\title{Validate the list of creation options that are handled by a driver}
\usage{
validateCreationOptions(format, options)
}
\arguments{
\item{format}{Character string giving a format driver short name
(e.g., \code{"GTiff"}).}

\item{options}{A character vector of format-specific creation options as
\code{"NAME=VALUE"} pairs.}
}
\value{
A logical value, \code{TRUE} if the given creation options are
compatible with the capabilities declared by the GDAL_DMD_CREATIONOPTIONLIST
metadata item for the specified format driver (or if the
GDAL_DMD_CREATIONOPTIONLIST metadata item is not defined for this driver),
otherwise \code{FALSE}.
}
\description{
\code{validateCreationOptions()} is a helper function primarily used by GDAL's
Create() and CreateCopy() to validate that the passed-in list of creation
options is compatible with the GDAL_DMD_CREATIONOPTIONLIST metadata item
defined by some drivers. If the GDAL_DMD_CREATIONOPTIONLIST metadata item
is not defined, this function will return \code{TRUE}. Otherwise it will check
that the keys and values in the list of creation options are compatible
with the capabilities declared by the GDAL_DMD_CREATIONOPTIONLIST metadata
item. In case of incompatibility a message will be emitted and \code{FALSE} will
be returned. Wrapper of \code{GDALValidateCreationOptions()} in the GDAL API.
}
\examples{
validateCreationOptions("GTiff", c("COMPRESS=LZW", "TILED=YES"))
}
\seealso{
\code{\link[=getCreationOptions]{getCreationOptions()}}, \code{\link[=create]{create()}}, \code{\link[=createCopy]{createCopy()}}
}
