# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Compute string extents.
#'
#' Determines the width and height of a bounding box that's big enough
#' to (just) enclose the provided text.
#'
#' @param x Character vector of of strings to measure
#' @param bold,italic Is text bold/italic?
#' @param fontname Font name
#' @param fontsize Font size
#' @examples
#' str_extents(letters)
#' str_extents("Hello World!", bold = TRUE, italic = FALSE,
#'   fontname = "sans", fontsize = 12)
#' @export
str_extents <- function(x, fontname = "sans", fontsize = 12, bold = FALSE, italic = FALSE) {
    .Call('gdtools_str_extents', PACKAGE = 'gdtools', x, fontname, fontsize, bold, italic)
}

#' Get font metrics for a string.
#'
#' @return A named numeric vector
#' @inheritParams str_extents
#' @examples
#' str_metrics("Hello World!")
#' @export
str_metrics <- function(x, fontname = "sans", fontsize = 12, bold = FALSE, italic = FALSE) {
    .Call('gdtools_str_metrics', PACKAGE = 'gdtools', x, fontname, fontsize, bold, italic)
}

#' Check if font family exists.
#'
#' @return A logical value
#' @param font_family font family name (case sensitive)
#' @examples
#' font_family_exists("sans")
#' font_family_exists("Arial")
#' font_family_exists("Courier")
#' @export
font_family_exists <- function(font_family = "sans") {
    .Call('gdtools_font_family_exists', PACKAGE = 'gdtools', font_family)
}

context_create <- function() {
    .Call('gdtools_context_create', PACKAGE = 'gdtools')
}

context_set_font <- function(cc, fontname, fontsize, bold, italic) {
    .Call('gdtools_context_set_font', PACKAGE = 'gdtools', cc, fontname, fontsize, bold, italic)
}

context_extents <- function(cc, x) {
    .Call('gdtools_context_extents', PACKAGE = 'gdtools', cc, x)
}

raster_to_str <- function(raster, w, h, width, height, interpolate) {
    .Call('gdtools_raster_to_str', PACKAGE = 'gdtools', raster, w, h, width, height, interpolate)
}

base64_raster_encode <- function(raster_, w, h, width, height, interpolate) {
    .Call('gdtools_base64_raster_encode', PACKAGE = 'gdtools', raster_, w, h, width, height, interpolate)
}

base64_file_encode <- function(filename) {
    .Call('gdtools_base64_file_encode', PACKAGE = 'gdtools', filename)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('gdtools_RcppExport_registerCCallable', PACKAGE = 'gdtools')
})
