% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_geelite.R,
%   R/run_geelite._halfgoogleimportR.R
\name{local_chunk_extract}
\alias{local_chunk_extract}
\title{Extract Statistics Locally for a Single Geometry Chunk}
\usage{
local_chunk_extract(sf_chunk, imgs, dates, band, stat, stat_fun, scale)

local_chunk_extract(sf_chunk, imgs, dates, band, stat, stat_fun, scale)
}
\arguments{
\item{sf_chunk}{[mandatory] (sf) An sf data frame containing geometry.}

\item{imgs}{[mandatory] (ee$ImageCollection) The Earth Engine image
collection to extract statistics from.}

\item{dates}{[mandatory] (character) A vector of date strings corresponding
to images in the collection.}

\item{band}{[mandatory] (character) The name of the band to extract.}

\item{stat}{[mandatory] (character) The statistical function to apply
(e.g., "mean").}

\item{stat_fun}{[mandatory] (ee$Reducer) The Earth Engine reducer function.}

\item{scale}{[mandatory] (numeric) The spatial resolution in meters for
reduce operations.}
}
\value{
(data.frame) A data frame containing extracted statistics with
  columns \code{id}, \code{band}, \code{zonal_stat}, and date-based values.

(data.frame) A data frame containing extracted statistics with
  columns \code{id}, \code{band}, \code{zonal_stat}, and date-based values.
}
\description{
Computes statistical summaries for a given spatial feature (\code{sf_chunk})
from an Earth Engine \code{ee$ImageCollection} over a specified date range.
This function extracts values for a specific band and applies a chosen
reducer.

Computes statistical summaries for a given spatial feature (\code{sf_chunk})
from an Earth Engine \code{ee$ImageCollection} over a specified date range.
This function extracts values for a specific band and applies a chosen
reducer.
}
\keyword{internal}
