/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.MCMCBond;
import gov.lanl.yadas.MCMCParameter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;

public class PowerBondArray
implements MCMCBond {
    MCMCBond[] rawbond;
    double powr;
    ArrayList paramlist;
    int[][] translator;
    PrintWriter out;
    NumberFormat nf;
    String direc;
    String nayme;

    public PowerBondArray(MCMCBond[] rawbond, double powr) {
        this(rawbond, powr, "", "weights");
    }

    public PowerBondArray(MCMCBond[] rawbond, double powr, String direc, String nayme) {
        int i;
        this.rawbond = rawbond;
        this.powr = powr;
        this.direc = direc;
        this.nayme = nayme;
        this.paramlist = new ArrayList();
        this.translator = new int[rawbond.length][];
        for (i = 0; i < rawbond.length; ++i) {
            ArrayList params = rawbond[i].getParamList();
            for (int j = 0; j < params.size(); ++j) {
                MCMCParameter tparam = (MCMCParameter)params.get(j);
                if (this.paramlist.contains(tparam)) continue;
                this.paramlist.add(tparam);
                tparam.addBond(this, this.paramlist.size() - 1);
            }
        }
        for (i = 0; i < rawbond.length; ++i) {
            int j;
            this.translator[i] = new int[this.paramlist.size()];
            ArrayList templist = new ArrayList();
            ArrayList params = rawbond[i].getParamList();
            for (j = 0; j < params.size(); ++j) {
                templist.add(params.get(j));
            }
            for (j = 0; j < this.paramlist.size(); ++j) {
                int ind;
                this.translator[i][j] = templist.contains(this.paramlist.get(j)) ? (ind = templist.indexOf(this.paramlist.get(j))) : -1;
            }
        }
        try {
            this.out = new PrintWriter(new FileWriter(direc + nayme + ".out"));
        }
        catch (IOException e) {
            System.out.println("IO Error: " + e);
            System.exit(0);
        }
        this.nf = NumberFormat.getNumberInstance();
        this.nf.setMaximumFractionDigits(3);
        this.nf.setGroupingUsed(false);
    }

    public double compute(int whatami, double cand, int which) {
        double summ = 0.0;
        for (int i = 0; i < this.rawbond.length; ++i) {
            if (this.translator[i][whatami] < 0) continue;
            summ += this.rawbond[i].compute(this.translator[i][whatami], cand, which);
        }
        return this.powr * summ;
    }

    public double compute(int whatami, double[] newpar) {
        double summ = 0.0;
        for (int i = 0; i < this.rawbond.length; ++i) {
            if (this.translator[i][whatami] < 0) continue;
            summ += this.rawbond[i].compute(this.translator[i][whatami], newpar);
        }
        return this.powr * summ;
    }

    public double compute(int[] whatami, double[][] newpar) {
        double summ = 0.0;
        for (int i = 0; i < this.rawbond.length; ++i) {
            int[] fromvec = new int[whatami.length];
            int[] transvec = new int[whatami.length];
            int k = 0;
            for (int j = 0; j < whatami.length; ++j) {
                if (this.translator[i][whatami[j]] < 0) continue;
                fromvec[k] = j;
                transvec[k++] = this.translator[i][whatami[j]];
            }
            int[] newwhatami = new int[k];
            double[][] newnewpar = new double[k][];
            for (int j = 0; j < k; ++j) {
                newwhatami[j] = transvec[j];
                newnewpar[j] = newpar[fromvec[j]];
            }
            summ += this.rawbond[i].compute(newwhatami, newnewpar);
        }
        return this.powr * summ;
    }

    public double compute(int[] whatami, double[][] newpar, int[] which) {
        double summ = 0.0;
        for (int i = 0; i < this.rawbond.length; ++i) {
            int[] fromvec = new int[whatami.length];
            int[] transvec = new int[whatami.length];
            int k = 0;
            for (int j = 0; j < whatami.length; ++j) {
                if (this.translator[i][whatami[j]] < 0) continue;
                fromvec[k] = j;
                transvec[k++] = this.translator[i][whatami[j]];
            }
            int[] newwhatami = new int[k];
            double[][] newnewpar = new double[k][];
            for (int j = 0; j < k; ++j) {
                newwhatami[j] = transvec[j];
                newnewpar[j] = newpar[which[fromvec[j]]];
            }
            summ += this.rawbond[i].compute(newwhatami, newnewpar);
        }
        return this.powr * summ;
    }

    public void revise() {
    }

    public void blank_value() {
    }

    public ArrayList getParamList() {
        return this.rawbond[0].getParamList();
    }

    public double getCurrentValue() {
        double summ = 0.0;
        for (int i = 0; i < this.rawbond.length; ++i) {
            summ += this.rawbond[i].getCurrentValue();
        }
        return this.powr * summ;
    }

    public String getName() {
        return "PowerBond_" + this.nayme;
    }

    public void setName(String name) {
        this.nayme = name;
    }

    public void output() {
        this.out.println(this.nf.format(-this.getCurrentValue()));
    }

    public void finish() {
        this.out.close();
    }
}

