/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.threading.activity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drugis.common.threading.CompositeTask;
import org.drugis.common.threading.SimpleTask;
import org.drugis.common.threading.Task;
import org.drugis.common.threading.TaskListener;
import org.drugis.common.threading.WaitingTask;
import org.drugis.common.threading.activity.ActivityModel;
import org.drugis.common.threading.event.ListenerManager;
import org.drugis.common.threading.event.TaskEvent;
import org.drugis.common.threading.event.TaskFailedEvent;
import org.drugis.common.threading.event.TaskFinishedEvent;
import org.drugis.common.threading.event.TaskRestartedEvent;
import org.drugis.common.threading.event.TaskStartedEvent;

public class ActivityTask
implements CompositeTask {
    private ListenerManager d_mgr = new ListenerManager(this);
    private final ActivityModel d_model;
    private boolean d_started = false;
    private String d_str;

    public ActivityTask(ActivityModel model, String str) {
        this.d_model = model;
        this.d_str = str;
        PhaseListener listener = new PhaseListener();
        for (Task t : this.d_model.getStates()) {
            t.addTaskListener(listener);
        }
    }

    public ActivityTask(ActivityModel model) {
        this(model, model.toString());
    }

    @Override
    public void addTaskListener(TaskListener l) {
        this.d_mgr.addTaskListener(l);
    }

    @Override
    public void removeTaskListener(TaskListener l) {
        this.d_mgr.removeTaskListener(l);
    }

    @Override
    public boolean isStarted() {
        return this.d_started;
    }

    @Override
    public boolean isFinished() {
        return this.d_model.isFinished();
    }

    @Override
    public boolean isFailed() {
        return this.getFailureCause() != null;
    }

    @Override
    public Throwable getFailureCause() {
        if (!this.isStarted() || this.isFinished()) {
            return null;
        }
        for (SimpleTask t : this.getNextTasks()) {
            if (!t.isFailed()) continue;
            return t.getFailureCause();
        }
        return null;
    }

    @Override
    public boolean isAborted() {
        return false;
    }

    @Override
    public List<SimpleTask> getNextTasks() {
        if (!this.isStarted()) {
            return Collections.emptyList();
        }
        ArrayList<SimpleTask> list = new ArrayList<SimpleTask>();
        for (Task t : this.d_model.getNextStates()) {
            if (t instanceof WaitingTask && !t.isFinished()) {
                WaitingTask wt = (WaitingTask)t;
                if (!wt.isStarted()) {
                    wt.onStartWaiting();
                }
                if (wt.isWaiting()) continue;
                wt.onEndWaiting();
                continue;
            }
            if (t instanceof SimpleTask) {
                list.add((SimpleTask)t);
                continue;
            }
            throw new RuntimeException("Unhandled Task type " + t.getClass());
        }
        return list;
    }

    @Override
    public void start() {
        this.d_started = true;
        this.d_mgr.fireTaskStarted();
    }

    public ActivityModel getModel() {
        return this.d_model;
    }

    public String toString() {
        return this.d_str;
    }

    private final class PhaseListener
    implements TaskListener {
        private PhaseListener() {
        }

        @Override
        public void taskEvent(TaskEvent event) {
            if (event instanceof TaskStartedEvent) {
                ActivityTask.this.d_mgr.firePhaseStarted(event.getSource());
            } else if (event instanceof TaskFinishedEvent) {
                ActivityTask.this.d_mgr.firePhaseFinished(event.getSource());
                if (event.getSource() == ActivityTask.this.d_model.getEndState()) {
                    ActivityTask.this.d_mgr.fireTaskFinished();
                }
            } else if (event instanceof TaskFailedEvent) {
                ActivityTask.this.d_mgr.fireTaskFailed(((TaskFailedEvent)event).getCause());
            } else if (event instanceof TaskRestartedEvent) {
                ActivityTask.this.d_mgr.firePhaseRestarted(event.getSource());
            }
        }
    }
}

