/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.parameterization;

import edu.uci.ics.jung.algorithms.transformation.FoldingTransformerFixed;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.drugis.common.stat.EstimateWithPrecision;
import org.drugis.mtc.model.Network;
import org.drugis.mtc.model.Study;
import org.drugis.mtc.model.Treatment;
import org.drugis.mtc.parameterization.BasicParameter;
import org.drugis.mtc.parameterization.ContinuousDataStartingValueGenerator;
import org.drugis.mtc.parameterization.DichotomousDataStartingValueGenerator;
import org.drugis.mtc.parameterization.StartingValueGenerator;
import org.drugis.mtc.util.DerSimonianLairdPooling;

public abstract class AbstractDataStartingValueGenerator
implements StartingValueGenerator {
    protected final Network d_network;
    private final RandomGenerator d_rng;
    private final double d_scale;
    private final UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> d_cGraph;

    public static StartingValueGenerator create(Network network, UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> cGraph, RandomGenerator rng, double scale) {
        switch (network.getType()) {
            case CONTINUOUS: {
                return new ContinuousDataStartingValueGenerator(network, cGraph, rng, scale);
            }
            case RATE: {
                return new DichotomousDataStartingValueGenerator(network, cGraph, rng, scale);
            }
        }
        throw new IllegalArgumentException("Don't know how to generate starting values for " + (Object)((Object)network.getType()) + " data");
    }

    public AbstractDataStartingValueGenerator(Network network, UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> cGraph, RandomGenerator rng, double scale) {
        this.d_network = network;
        this.d_rng = rng;
        this.d_scale = scale;
        this.d_cGraph = cGraph;
    }

    protected abstract EstimateWithPrecision estimateRelativeEffect(Study var1, BasicParameter var2);

    protected abstract EstimateWithPrecision estimateTreatmentEffect(Study var1, Treatment var2);

    @Override
    public double getTreatmentEffect(Study study, Treatment treatment) {
        return this.generate(this.estimateTreatmentEffect(study, treatment));
    }

    @Override
    public double getRelativeEffect(Study study, BasicParameter p) {
        return this.generate(this.estimateRelativeEffect(study, p));
    }

    @Override
    public double getRelativeEffect(BasicParameter p) {
        return this.generate(this.getPooledEffect(p));
    }

    @Override
    public double getStandardDeviation() {
        double[] errors = new double[this.d_cGraph.getEdgeCount()];
        int i = 0;
        for (FoldingTransformerFixed.FoldedEdge edge : this.d_cGraph.getEdges()) {
            Pair v = edge.getVertices();
            errors[i++] = this.getPooledEffect(new BasicParameter((Treatment)v.getFirst(), (Treatment)v.getSecond())).getStandardError();
        }
        if (this.d_rng == null) {
            return new Mean().evaluate(errors);
        }
        return errors[this.d_rng.nextInt(errors.length)];
    }

    private EstimateWithPrecision getPooledEffect(BasicParameter p) {
        return new DerSimonianLairdPooling(this.estimateRelativeEffects(p)).getPooled();
    }

    private double generate(EstimateWithPrecision estimate) {
        if (this.d_rng == null) {
            return estimate.getPointEstimate();
        }
        return estimate.getPointEstimate() + this.d_rng.nextGaussian() * this.d_scale * estimate.getStandardError();
    }

    protected List<EstimateWithPrecision> estimateRelativeEffects(BasicParameter p) {
        final Pair<Treatment> treatments = new Pair<Treatment>(p.getBaseline(), p.getSubject());
        HashSet<Study> studies = new HashSet<Study>(this.d_network.getStudies());
        CollectionUtils.filter(studies, new Predicate<Study>(){

            @Override
            public boolean evaluate(Study study) {
                return study.getTreatments().containsAll(treatments);
            }
        });
        ArrayList<EstimateWithPrecision> estimates = new ArrayList<EstimateWithPrecision>(studies.size());
        for (Study s : studies) {
            estimates.add(this.estimateRelativeEffect(s, p));
        }
        return estimates;
    }
}

