/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.summary;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.correlation.StorelessCovariance;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.drugis.common.beans.AbstractObservable;
import org.drugis.mtc.MCMCResults;
import org.drugis.mtc.MCMCResultsEvent;
import org.drugis.mtc.MCMCResultsListener;
import org.drugis.mtc.Parameter;
import org.drugis.mtc.summary.MultivariateNormalSummary;
import org.drugis.mtc.summary.Summary;
import org.drugis.mtc.summary.SummaryUtil;

public class MCMCMultivariateNormalSummary
extends AbstractObservable
implements MCMCResultsListener,
Summary,
MultivariateNormalSummary {
    private final MCMCResults d_results;
    private final Parameter[] d_parameters;
    private double[][] d_covMatrix;
    private double[] d_means;
    private boolean d_isDefined = false;

    public MCMCMultivariateNormalSummary(MCMCResults results, Parameter[] parameters) {
        this.d_results = results;
        this.d_parameters = parameters;
        this.d_means = new double[this.getParameters().length];
        this.d_covMatrix = new double[this.getParameters().length][this.getParameters().length];
        this.calculateResults();
        this.d_results.addResultsListener(this);
    }

    public Parameter[] getParameters() {
        return this.d_parameters;
    }

    public boolean getDefined() {
        return this.d_isDefined;
    }

    public void resultsEvent(MCMCResultsEvent event) {
        this.calculateResults();
    }

    public double[] getMeanVector() {
        return this.d_means;
    }

    public double[][] getCovarianceMatrix() {
        return this.d_covMatrix;
    }

    private boolean isReady() {
        return this.d_results.getNumberOfSamples() >= 4;
    }

    private void calculateResults() {
        if (!this.isReady()) {
            return;
        }
        ArrayList<List<Double>> sampleCache = new ArrayList<List<Double>>();
        for (int i = 0; i < this.getParameters().length; ++i) {
            List<Double> samples = SummaryUtil.getAllChainsLastHalfSamples(this.d_results, this.getParameters()[i]);
            sampleCache.add(samples);
            this.d_means[i] = SummaryUtil.evaluate(new Mean(), samples);
        }
        StorelessCovariance cov = new StorelessCovariance(this.getParameters().length);
        double[] rowData = new double[this.getParameters().length];
        for (int row = 0; row < ((List)sampleCache.get(0)).size(); ++row) {
            for (int col = 0; col < this.getParameters().length; ++col) {
                rowData[col] = (Double)((List)sampleCache.get(col)).get(row);
            }
            cov.increment(rowData);
        }
        this.d_covMatrix = cov.getData();
        boolean wasDefined = this.d_isDefined;
        this.d_isDefined = true;
        this.firePropertyChange("defined", wasDefined, this.d_isDefined);
        this.firePropertyChange("meanVector", null, this.d_means);
        this.firePropertyChange("covarianceMatrix", null, this.d_covMatrix);
    }
}

