/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.DataFrame;
import gov.lanl.yadas.MCMCBond;
import gov.lanl.yadas.MCMCParameter;
import gov.lanl.yadas.MCMCUpdate;
import gov.lanl.yadas.ScalarFrame;
import java.util.ArrayList;

public class MCMC {
    int progressreport = 1000;
    int skip = 1;
    String direc;
    ArrayList filenames = new ArrayList();
    ArrayList d = new ArrayList();
    ArrayList d0 = new ArrayList();
    ArrayList paramlist = new ArrayList();
    ArrayList paramnames = new ArrayList();
    ArrayList bondlist = new ArrayList();
    ArrayList bondnames = new ArrayList();
    ArrayList updatelist = new ArrayList();
    ArrayList updatenames = new ArrayList();

    public MCMC(String direc) {
        this.direc = direc;
    }

    public void addDataFrame(DataFrame dframe) {
        this.d.add(dframe);
    }

    public void addScalarFrame(ScalarFrame sframe) {
        this.d0.add(sframe);
    }

    public void addParameter(MCMCParameter param) {
        this.paramlist.add(param);
    }

    public void addBond(MCMCBond bond) {
        this.bondlist.add(bond);
    }

    public void addUpdate(MCMCUpdate upd) {
        this.updatelist.add(upd);
    }

    public void setDirec(String direc) {
        this.direc = direc;
    }

    public void iterate(int B) {
        for (int b = 0; b < B; ++b) {
            int i;
            if ((double)b / (double)this.progressreport - (double)(b / this.progressreport) == 0.0) {
                System.out.println(b);
            }
            for (i = 0; i < this.updatelist.size(); ++i) {
                ((MCMCUpdate)this.updatelist.get(i)).update();
            }
            for (i = 0; i < this.paramlist.size(); ++i) {
                ((MCMCParameter)this.paramlist.get(i)).output();
            }
        }
    }

    public void finish() {
        for (int iii = 0; iii < this.updatelist.size(); ++iii) {
            String acc = ((MCMCUpdate)this.updatelist.get(iii)).accepted();
            System.out.println("Update " + iii + ": " + acc);
        }
        for (int i = 0; i < this.paramlist.size(); ++i) {
            ((MCMCParameter)this.paramlist.get(i)).finish();
        }
    }
}

