/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.yadas;

import gov.lanl.yadas.MCMCParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.drugis.mtc.MCMCResults;
import org.drugis.mtc.MCMCResultsEvent;
import org.drugis.mtc.MCMCResultsListener;
import org.drugis.mtc.Parameter;
import org.drugis.mtc.yadas.Derivation;
import org.drugis.mtc.yadas.ParameterWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YadasResults
implements MCMCResults {
    private Parameter[] d_directParameters;
    private Parameter[] d_derivedParameters;
    private Derivation[] d_derivations;
    private int d_nChains;
    private int d_availableSamples;
    private int d_reservedSamples;
    private List<List<double[]>> d_results;
    private List<MCMCResultsListener> d_listeners = new ArrayList<MCMCResultsListener>();

    public YadasResults() {
        this.initialize();
    }

    @Override
    public void clear() {
        this.d_availableSamples = 0;
        this.d_reservedSamples = 0;
        this.initResults();
    }

    private void initialize() {
        this.d_directParameters = new Parameter[0];
        this.d_derivedParameters = new Parameter[0];
        this.d_derivations = new Derivation[0];
        this.d_nChains = 0;
        this.clear();
    }

    public void setDirectParameters(List<Parameter> parameters) {
        this.d_directParameters = new Parameter[parameters.size()];
        int i = 0;
        while (i < parameters.size()) {
            this.d_directParameters[i] = parameters.get(i);
            ++i;
        }
        this.initResults();
    }

    public void setDerivedParameters(Map<? extends Parameter, Derivation> derivations) {
        this.d_derivedParameters = new Parameter[derivations.size()];
        this.d_derivations = new Derivation[derivations.size()];
        int i = 0;
        for (Map.Entry<? extends Parameter, Derivation> e : derivations.entrySet()) {
            this.d_derivedParameters[i] = e.getKey();
            this.d_derivations[i] = e.getValue();
            ++i;
        }
    }

    @Override
    public Parameter[] getParameters() {
        return this.d_directParameters;
    }

    @Override
    public int findParameter(Parameter p) {
        int idx = ArrayUtils.indexOf(this.d_directParameters, p);
        if (idx >= 0) {
            return idx;
        }
        idx = ArrayUtils.indexOf(this.d_derivedParameters, p);
        if (idx >= 0) {
            idx += this.d_directParameters.length;
        }
        return idx;
    }

    public ParameterWriter getParameterWriter(Parameter p, int cIdx, MCMCParameter mp, int i) {
        return new YadasParameterWriter(this.findParameter(p), cIdx, mp, i);
    }

    @Override
    public double getSample(int p, int c, int i) {
        if (c < 0 || c >= this.d_nChains) {
            throw new IndexOutOfBoundsException("Chain " + c + " out of bounds: " + this.d_nChains + " chains available.");
        }
        int nDirect = this.d_directParameters.length;
        int nDerived = this.d_derivedParameters.length;
        if (p < 0 || p >= nDirect + nDerived) {
            throw new IndexOutOfBoundsException("Parameter " + p + " out of bounds: " + nDirect + " + " + nDerived + " parameters available.");
        }
        if (i < 0 || i >= this.d_availableSamples) {
            throw new IndexOutOfBoundsException("Iteration " + i + " out of bounds: " + this.d_availableSamples + " iterations available.");
        }
        return p < nDirect ? this.d_results.get(c).get(p)[i] : this.d_derivations[p - nDirect].calculate(this, c, i);
    }

    public void setNumberOfChains(int nChains) {
        this.d_nChains = nChains;
        this.initResults();
    }

    private void initResults() {
        this.d_results = new ArrayList<List<double[]>>(this.d_nChains);
        int i = 0;
        while (i < this.d_nChains) {
            ArrayList<double[]> list = new ArrayList<double[]>(this.d_directParameters.length);
            int j = 0;
            while (j < this.d_directParameters.length) {
                list.add(new double[this.d_reservedSamples]);
                ++j;
            }
            this.d_results.add(list);
            ++i;
        }
    }

    @Override
    public int getNumberOfChains() {
        return this.d_nChains;
    }

    public void setNumberOfIterations(int iter) {
        this.d_reservedSamples = iter;
        for (List<double[]> chain : this.d_results) {
            int i = 0;
            while (i < chain.size()) {
                double[] newResults = new double[iter];
                System.arraycopy(chain.get(i), 0, newResults, 0, chain.get(i).length);
                chain.set(i, newResults);
                ++i;
            }
        }
    }

    public int getNumberOfIterations() {
        return this.d_reservedSamples;
    }

    @Override
    public int getNumberOfSamples() {
        return this.d_availableSamples;
    }

    public void simulationFinished() {
        this.d_availableSamples = this.d_reservedSamples;
        MCMCResultsEvent event = new MCMCResultsEvent(this);
        ArrayList<MCMCResultsListener> listeners = new ArrayList<MCMCResultsListener>(this.d_listeners);
        for (MCMCResultsListener l : listeners) {
            l.resultsEvent(event);
        }
    }

    @Override
    public void addResultsListener(MCMCResultsListener l) {
        this.d_listeners.add(l);
    }

    @Override
    public void removeResultsListener(MCMCResultsListener l) {
        this.d_listeners.remove(l);
    }

    private class YadasParameterWriter
    extends ParameterWriter {
        private final int d_pIdx;
        private final int d_cIdx;
        private int d_idx;

        public YadasParameterWriter(int pIdx, int cIdx, MCMCParameter mp, int i) {
            super(mp, i);
            this.d_pIdx = pIdx;
            this.d_cIdx = cIdx;
            this.d_idx = 0;
        }

        protected void write(double value) {
            ((double[])((List)((YadasResults)YadasResults.this).d_results.get((int)this.d_cIdx)).get((int)this.d_pIdx))[this.d_idx++] = value;
        }
    }
}

