% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config_handling.R
\name{prepare_directories}
\alias{prepare_directories}
\title{checks if the necessary directories exist, and otherwise creates them.
This function will be called by the simulation, but is made available if the directories should be created
manually beforehand, for example to redirect the stdout to a file in the output directory.}
\usage{
prepare_directories(
  config_file = NA,
  input_directory = NA,
  output_directory = NA
)
}
\arguments{
\item{config_file}{path to the config file, if NA the default config will be used}

\item{input_directory}{path to input directory, if NA it will be derived from the config file path}

\item{output_directory}{path to output directory, if NA it will be derived from the config file path}
}
\value{
returns a named list with the paths for the input and output directories
}
\description{
checks if the necessary directories exist, and otherwise creates them.
This function will be called by the simulation, but is made available if the directories should be created
manually beforehand, for example to redirect the stdout to a file in the output directory.
}
\examples{
\dontrun{
  # this is an internal function used to attribute directories by deduction
  # called at the start of a simulation run
  datapath <- system.file(file.path("extdata", "WorldCenter"), package = "gen3sis")
  # deducing input directory and setting output directory
  prepare_directories(config_file = file.path(datapath, "config/config_worldcenter.R"))
  # setting output directory
  prepare_directories(config_file = file.path(datapath, "config/config_worldcenter.R"), 
                      input_directory = file.path(datapath, "landscape"))
}
}
