% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{createGephiFile}
\alias{createGephiFile}
\title{Creating a Gephi File}
\usage{
createGephiFile(BC_dat, minHD = 1, loga = TRUE, ori_BCs = NULL,
  col_type = "rainbow")
}
\arguments{
\item{BC_dat}{a BCdat object}

\item{minHD}{an integer value representing the maximal hamming distance value for which the graph will
contain edges}

\item{loga}{a logical value indicating the use or non-use of logarithmic read count values}

\item{ori_BCs}{a vector of character strings containing the initial barcode sequences}

\item{col_type}{character sting, choosing one of the available color palettes}
}
\description{
createGephiFile creates a data file usable with the free graph visualisation tool gephi. The nodes
represent barcodes and its respective size reflects the corresponding read counts. Edges between nodes indicate
a hamming distance between two barcodes of maximal \code{minHD}.
If \code{ori_BCs} is provided the node color refelects the hamming distance of a particular barcode to one
of the provided barcode sequences.
}
\examples{

\dontrun{

data(BC_dat)
createGephiFile(BC_dat, minHD = 1, loga = TRUE, ori_BCs = NULL, col_type = "rainbow")

}
}
