% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{ggplotHammDistGraph}
\alias{ggplotHammDistGraph}
\title{Plotting a Hamming Distance Network}
\usage{
ggplotHammDistGraph(BC_dat, minHD = 1, loga = TRUE, ori_BCs = NULL,
  lay = "fruchtermanreingold", complete = TRUE, col_type = "rainbow",
  outline = 0.5)
}
\arguments{
\item{BC_dat}{a BCdat object.}

\item{minHD}{an integer value representing the maximal hamming distance for which the graph will
contain edges.}

\item{loga}{a logical value, indicating the use or non-use of logarithmic read count values.}

\item{ori_BCs}{a vector of character strings containing the initial barcode sequences.}

\item{lay}{a character string, identifying the prefered layout algorithm (see ggnetwork layout option).}

\item{complete}{a logical value. If TRUE, every node will have at least one edge.}

\item{col_type}{a character sting, choosing one of the available color palettes.}

\item{outline}{an integer value which adjusts the thickness of the black outline of each node.}
}
\value{
a ggplot2 object
}
\description{
ggplotHammDistGraph will create a graph-like visualisation (ripple plot) of the corresponding barcode sequences
and their similarity based on the ggplot2 and the ggnetwork packages. The nodes represent the barcode sequences and their
respective size reflects the corresponding read counts. Edges between nodes indicate a hamming distance between two barcodes
of maximal \code{minHD}.
If \code{ori_BCs} is provided the node color also refelects the hamming distance of a particular barcode to one of the initial
barcodes.
}
\examples{

\dontrun{

data(BC_dat)
ggplotHammDistGraph(BC_dat, minHD = 1, loga = TRUE, ori_BCs = NULL, lay = "fruchtermanreingold",
complete = FALSE, col_type = "rainbow")

}

}
