% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_data_processing.R
\name{qualityFiltering}
\alias{qualityFiltering}
\title{Quality Filtering}
\usage{
qualityFiltering(file_name, source_dir, results_dir, min_score = 30)
}
\arguments{
\item{file_name}{a character string containing the name of the source file.}

\item{source_dir}{a character string containing the path to the source directory.}

\item{results_dir}{a character string containing the path to the directory of the results.}

\item{min_score}{an integer value representing the minimal average phred score a read has to achieve in order to be accepted.}
}
\value{
a ShortRead object.
}
\description{
Excludes all sequences of a given fastq file below a certain quality value.
}
\examples{
source_dir <- system.file("extdata", package = "genBaRcode")
qualityFiltering(file_name = "test_data.fastq", source_dir, results_dir = getwd(), min_score = 30)
}
