% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_phenotype.R
\name{read_phenotype}
\alias{read_phenotype}
\title{Read phenotype from .fam file}
\usage{
read_phenotype(filename, sep = " ", header = FALSE,
  stringAsFactors = FALSE)
}
\arguments{
\item{filename}{character, name of file with phenotype}

\item{sep}{character, field seperator in file}

\item{header}{logical, does first row of file contain variables names}

\item{stringAsFactors}{logical, should character vectors be converted to factors?}
}
\value{
object of class phenotypeData
}
\description{
Reading phenotype data from file. It is assumed, that data is given in .fam file.
In this format, first column is family id (FID), second is individual id (IID),
third is Paternal individual ID (PAT), fourth is  Maternal individual ID (MAT),
fifth is SEX and sixth and last is PHENOTYPE.
If file has only four columns, then it is assumed that PAT and MAT columns are missing.
If there is only one column, then it is assumed that only phenotype is provided.
}

