% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_fam.R
\name{make_fam}
\alias{make_fam}
\title{Create a plink FAM tibble}
\usage{
make_fam(tib, n = NA)
}
\arguments{
\item{tib}{The input tibble (optional).
Missing columns will be autocompleted with reasonable values that are accepted by plink and other external software.}

\item{n}{The desired number of individuals (rows).
Required if \code{tib} is missing; otherwise it is ignored.}
}
\value{
The input tibble with autocompleted columns and columns in default order, or the made up tibble if only the number of individuals was provided.
The output begins with the standard columns in standard order: fam, id, pat, mat, sex, pheno.
Additional columns in the input tibble are preserved but placed after the standard columns.
}
\description{
This function simplifies the creation of plink FAM-formatted tibbles, which autocompletes missing information if a partial tibble is provided, or generates a completely made up tibble if the number of individuals is provided.
The default values are most useful for simulated genotypes, where IDs can be made up but must be unique, and there are no parents, families, gender, or phenotype.
}
\details{
Autocompleted column values:
\describe{
\item{fam:}{ \code{1:n} }
\item{id:}{ \code{1:n} }
\item{pat:}{ \code{0} (missing) }
\item{mat:}{ \code{0} (missing) }
\item{sex:}{ \code{0} (missing) }
\item{pheno:}{ \code{0} (missing) }
}
Note that \eqn{n} is either given directly or obtained from the input tibble.
}
\examples{
# create a synthetic tibble for 10 individuals
# (most common use case)
fam <- make_fam(n = 10)

# manually create a partial tibble with only phenotypes defined
library(tibble)
fam <- tibble(pheno = 0:2)
# autocomplete the rest of the columns
fam <- make_fam(fam)

}
\seealso{
Plink FAM format reference:
\url{https://www.cog-genomics.org/plink/1.9/formats#fam}
}
