% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_grm.R
\name{write_grm}
\alias{write_grm}
\title{Write GCTA GRM binary files}
\usage{
write_grm(name, kinship, M = NULL, fam = NULL, verbose = TRUE)
}
\arguments{
\item{name}{The base name of the output files.  Files with that base and extensions \code{.grm.bin}, \code{.grm.N.bin}, and \code{.grm.id} may be created depending on the data provided.}

\item{kinship}{The symmetric \code{n}-times-\code{n} kinship matrix to write into file with extension \code{.grm.bin}.}

\item{M}{The optional symmetric \code{n}-times-\code{n} matrix of pair sample sizes to write into file with extension \code{.grm.N.bin}.}

\item{fam}{The optional data.frame or tibble with individual annotations (columns with names \code{fam} and \code{id}, subset of columns of Plink FAM) to write into file with extension \code{.grm.id}.
If \code{fam} is \code{NULL} but \code{kinship} has non-\code{NULL} column or row names, these are used as the second (\code{id}) value in the output table (the first (\code{fam}) column is set to the missing value in this case).}

\item{verbose}{If \code{TRUE} (default), function reports the path of the files being written.}
}
\description{
This function writes a GCTA Genetic Relatedness Matrix (GRM, i.e. kinship) set of files in their binary format, given a kinship matrix and, if available, the corresponding matrix of pair sample sizes (non-trivial under missingness) and individuals table.
}
\examples{
# to write existing data `kinship`, `M`, and `fam` into files "data.grm.bin" etc, run like this:
# write_grm("data", kinship, M = M, fam = fam )

# The following example is more detailed but also more awkward
# because (only for these examples) the package must create the file in a *temporary* location

# create dummy data to write
# kinship for 3 individuals
kinship <- matrix(
    c(
        0.6, 0.2, 0.0,
        0.2, 0.5, 0.1,
        0.0, 0.1, 0.5
    ),
    nrow = 3
)
# pair sample sizes matrix
M <- matrix(
    c(
        10, 9, 8,
         9, 9, 7,
         8, 7, 8
    ),
    nrow = 3
)
# individual annotations table
library(tibble)
fam <- tibble(
    fam = 1:3,
    id = 1:3
)
# dummy files to write and delete
name <- tempfile('delete-me-example') # no extension
# write the data now!
write_grm( name, kinship, M = M, fam = fam )
# delete outputs when done
delete_files_grm( name )

}
\seealso{
\code{\link[=read_grm]{read_grm()}}
}
