% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9_fun_all.part.pls.R
\name{all.part.pls}
\alias{all.part.pls}
\title{Defining the candidates to the optimum partition for each of segmentation variables}
\usage{
\method{all}{part.pls}(x, y, inner, outer, mode, scheme, scaling, scaled, method, n.node, ...)
}
\arguments{
\item{x}{matrix or data frame containing the data.}

\item{y}{matrix or data.frame of the segmentation variables.}

\item{inner}{A square (lower triangular) boolean matrix representing the inner 
model (i.e. the path relationships between latent variables).}

\item{outer}{list of vectors with column indices or column names from Data indicating 
the sets of manifest variables forming each block (i.e. which manifest variables correspond to each block).}

\item{mode}{character vector indicating the type of measurement for each
block. Possible values are: \code{"A", "B", "newA", "PLScore", "PLScow"}. 
The length of \code{mode} must be equal to the length of \code{outer}.}

\item{scheme}{string indicating the type of inner weighting
scheme. Possible values are \code{"centroid"}, \code{"factorial"}, or
\code{"path"}.}

\item{scaling}{optional list of string vectors indicating the type of 
measurement scale for each manifest variable specified in \code{blocks}.
\code{scaling} must be specified when working with non-metric variables.
Possible values: \code{"num"} (numeric), \code{"raw"}, \code{"nom"} (nominal), 
and \code{"ord"} (ordinal).}

\item{scaled}{whether manifest variables should be standardized. 
Only used when \code{scaling = NULL}. When (\code{TRUE}, data is 
scaled to standardized values (mean=0 and variance=1).}

\item{method}{string indicating the method: LM or LAD}

\item{n.node}{number indicating a stop condition}

\item{\dots}{Further arguments passed on to \code{\link{all.part.pls}}.}
}
\value{
list containing information of the candidates to the optimum partition for each of segmentation variables
}
\description{
Defining the candidates to the optimum partition for each of segmentation variables
}
\details{
Internal function. \code{all.part.pls} is called by \code{partopt.pls}.
}
\keyword{internal}
