% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{mcsglmm}
\alias{mcsglmm}
\title{MCMC samples from the Spatial GLMM}
\usage{
mcsglmm(formula, family = c("gaussian", "binomial", "poisson", "Gamma"), data,
  weights, subset, atsample, Nout, Nthin = 1, Nbi = 0, betm0, betQ0, ssqdf,
  ssqsc, phipars, omgpars, corrfcn = c("matern", "spherical", "power"), kappa,
  linkp, phisc, omgsc, zstart, phistart, omgstart, dispersion = 1,
  longlat = FALSE, test = FALSE)
}
\arguments{
\item{formula}{A representation of the model in the form
\code{response ~ terms}. The response is must be set to
\code{NA}'s at the prediction locations. At the observed locations
the response is assumed to be a total of replicated measurements.
The number of replications is inputted using the argument
\code{weights}.}

\item{family}{The distribution of the data.}

\item{data}{An optional data frame containing the variables in the
model.}

\item{weights}{An optional vector of weights. Number of replicated
samples for Gaussian and gamma, number of trials for binomial,
time length for Poisson.}

\item{subset}{An optional vector specifying a subset of
observations to be used in the fitting process.}

\item{atsample}{A formula in the form \code{~ x1 + x2 + ... + xd}
with the coordinates of the sampled locations.}

\item{Nout}{Number of MCMC samples to return.}

\item{Nthin}{The thinning of the MCMC algorithm.}

\item{Nbi}{The burn-in of the MCMC algorithm.}

\item{betm0}{Prior mean for beta (a vector or scalar).}

\item{betQ0}{Prior standardised precision (inverse variance)
matrix.}

\item{ssqdf}{Degrees of freedom for the scaled inverse chi-square
prior for the partial sill parameter.}

\item{ssqsc}{Scale for the scaled inverse chi-square prior for the
partial sill parameter.}

\item{phipars}{Parameters for the generalized inverse gamma prior
for the range parameter \code{phi}. A four dimensional vector with
parameters scale, shape, exponent, location in that order.}

\item{omgpars}{Parameters for the generalized inverse gamma prior
for the relative nugget parameter \code{omg}. A four dimensional
vector with parameters scale, shape, exponent, location in that
order.}

\item{corrfcn}{Spatial correlation function.}

\item{kappa}{Spatial correlation parameter. Smoothness parameter
for Matern, exponent for the power family.}

\item{linkp}{Parameter of the link function. For binomial, a
positive number for the degrees of freedom of the robit family or
"logit" or "probit". For the other families any number for the
exponent of the Box-Cox transformation.}

\item{phisc}{Random walk parameter for \code{phi}. Smaller values
increase the acceptance ratio. Set this to 0 for fixed \code{phi}.
In this case the fixed value is given in the argument
\code{phistart}.}

\item{omgsc}{Random walk parameter for \code{omg}. Smaller values
increase the acceptance ratio. Set this to 0 for fixed \code{omg}.
In this case the fixed value is given in the argument
\code{omgstart}.}

\item{zstart}{Starting value for the MCMC for the GRF. Defaults to
0.}

\item{phistart}{Starting value for the MCMC for \code{phi}.
Defaults to the mean of its prior.}

\item{omgstart}{Starting value for the MCMC for \code{omg}.
Defaults to the mean of its prior.}

\item{dispersion}{The fixed dispersion parameter.}

\item{longlat}{How to compute the distance between locations. If
\code{FALSE}, Euclidean distance, if \code{TRUE} Great Circle
distance. See \code{\link[sp]{spDists}}.}

\item{test}{Whether this is a trial run to monitor the acceptance
ratio of the random walk for \code{phi} and \code{omg}. If set to
\code{TRUE}, the acceptance ratio will be printed on the screen
every 100 iterations of the MCMC. Tune the \code{phisc} and
\code{omgsc} parameters in order to achive 20 to 30\% acceptance.
Set this to a positive number to change the default 100. No
thinning or burn-in are done when testing.}
}
\value{
A list containing the MCMC samples and other variables as
follows:
\itemize{
 \item \code{z} A matrix containing the MCMC samples for the
spatial random field. Each column is one sample.
 \item \code{beta} A matrix containing the MCMC samples for the
regressor coefficients. Each column is one sample.
 \item \code{ssq} A vector with the MCMC samples for the partial
 \item \code{tsq} A vector with the MCMC samples for the
measurement error variance.
 \item \code{phi} A vector with the MCMC samples for the spatial
range parameter.
 \item \code{omg} A vector with the MCMC samples for the relative
nugget parameter.
 \item \code{nu} The link function parameter translated to
numeric code used internally.
 \item \code{logLik} A vector containing the value of the
log-likelihood evaluated at each sample.
 \item \code{acc_ratio} The acceptance ratio for the joint update
of the parameters \code{phi} and \code{omg}.
 \item \code{sys_time} The total computing time for the MCMC sampling.
 \item \code{Nout}, \code{Nbi},  \code{Nthin} As in input. Used
internally in other functions.
 \item \code{response} The value of the response variable at the
observed locations. Used internally in other functions.
 \item \code{weights} The response weights at the observed
locations. Used internally in other functions.
 \item \code{modelmatrix} The model matrix at the observed
locations. Used internally in other functions.
 \item \code{family} As in input. Used internally in other functions.
 \item \code{betm0}, \code{betQ0}, \code{ssqdf}, \code{ssqsc},
\code{corrfcn}, \code{kappa}, \code{dispersion} As in
input. Used internally in other functions.
 \item \code{locations} Coordinates of the observed locations.
Used internally in other functions.
 \item \code{whichobs} A logical vector indicated which rows in
the data and in the MCMC samples for the spatial random field
correspond to the observed locations.
}
}
\description{
Draw MCMC samples from the Spatial GLMM with known link function
}
\details{
Simulates from the posterior distribution of this model.
}

