% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side_functions.R
\name{mapClusters}
\alias{mapClusters}
\title{Mapping the clusters}
\usage{
mapClusters(geodata = NULL, object, undecided = NULL)
}
\arguments{
\item{geodata}{An object of class features collection from sf /
ordered like the original data used for the clustering. Can be Null if object is
a FCMres and has been created with rasters.}

\item{object}{A FCMres object, typically obtained from functions CMeans,
GCMeans, SFCMeans, SGFCMeans. Can also be a simple membership matrix.}

\item{undecided}{A float between 0 and 1 giving the minimum value that an
observation must get in the membership matrix to not be considered as
uncertain (default = NULL)}
}
\value{
A named list with :
\itemize{
        \item ProbaMaps : a list of tmap maps showing for each group the
        probability of the observations to belong to that group
        \item ClusterMap : a tmap map showing the most likely group for
         observation
}
}
\description{
Build some maps to visualize the results of the clustering
}
\examples{
\dontrun{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- sf::st_drop_geometry(LyonIris[AnalysisFields])
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, standardize = TRUE)
MyMaps <- mapClusters(LyonIris, result$Belongings)
}
}
