% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessRaster.R
\name{assessRaster}
\alias{assessRaster}
\title{assessRaster}
\usage{
assessRaster(
  reference,
  predicted,
  multiclass = TRUE,
  mappings = levels(as.factor(reference)),
  decimals = 4
)
}
\arguments{
\item{reference}{SpatRaster object of reference class codes/indices.}

\item{predicted}{SpatRaster object of reference class codes/indices.}

\item{multiclass}{TRUE or FALSE. If more than two classes are differentiated,
use TRUE. If only two classes are differentiated and there are positive and
background/negative classes, use FALSE. Default is TRUE.}

\item{mappings}{Vector of class names. These must be in the same order
as the class indices or class names so that they are correctly matched to the correct category.
If no mappings are provided, then the factor levels or class indices are used by default.
For a binary classification, it is assumed that the first class is "Background" and
the second class is "Positive".}

\item{decimals}{Number of decimal places to return for assessment metrics. Default is 4.}
}
\value{
List object containing the resulting metrics and ancillary information.
}
\description{
Assess semantic segmentation model using categorical raster grids (wall-to-wall
reference data and predictions)
}
\details{
This function generates a set of summary assessment metrics when provided
reference and predicted classes. Results are returned as a list object. For
multiclass assessment, the class names ($Classes), count of samples per class
in the reference data ($referenceCounts), count of samples per class in the
predictions ($predictionCounts), confusion matrix ($confusionMatrix),
aggregated assessment metrics ($aggMetrics) (OA = overall accuracy, macroF1 = macro-averaged
class aggregated F1-score, macroPA = macro-averaged class aggregated producer's
accuracy or recall, and macroUA = macro-averaged class aggregated user's accuracy or
precision), class-level user's accuracies or precisions ($userAccuracies),
class-level producer's accuracies or recalls ($producerAccuracies), and class-level
F1-scores ($F1Scores). For a binary case, the $Classes, $referenceCounts,
$predictionCounts, and $confusionMatrix objects are also returned; however, the $aggMets
object is replaced with $Mets, which stores the following metrics: overall accuracy, recall,
precision, specificity, negative predictive value (NPV), and F1-score.
For binary cases, the second class is assumed to be the positive case.
}
\examples{
if(requireNamespace("terra", quietly = TRUE)){
require(torch)
require(terra)
#Multiclass example

#Generate example data as SpatRasters
ref <- terra::rast(matrix(sample(c(1, 2, 3), 625, replace=TRUE), nrow=25, ncol=25))
pred <- terra::rast(matrix(sample(c(1, 2, 3), 625, replace=TRUE), nrow=25, ncol=25))

#Calculate metrics
metsOut <- assessRaster(reference=ref,
                        predicted=pred,
                        multiclass=TRUE,
                        mappings=c("Class A", "Class B", "Class C"),
                        decimals=4)

print(metsOut)

#Binary example

#Generate example data as SpatRasters
ref <- terra::rast(matrix(sample(c(0, 1), 625, replace=TRUE), nrow=25, ncol=25))
pred <- terra::rast(matrix(sample(c(0, 1), 625, replace=TRUE), nrow=25, ncol=25))

#Calculate metrics
metsOut <- assessRaster(reference=ref,
                        predicted=pred,
                        multiclass=FALSE,
                        mappings=c("Background", "Positive"),
                        decimals=4)

print(metsOut)
}
}
