% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRaw.r
\name{plotRawHeight}
\alias{plotRawHeight}
\title{Plot Raw Data Points considering Topography}
\usage{
plotRawHeight(Profile, height = Profile@rawData@height, spline = TRUE,
  xlab = "Length [m]", ylab = "Depth [m]", main = paste(Profile@title,
  "without topography"), ...)
}
\arguments{
\item{Profile}{profile.}

\item{height}{topo data frame of distances and height.
Use "Profile@xyzData@height" instead.}

\item{spline}{if TRUE spline interpolation is conducted.}

\item{xlab}{label for x-axes.}

\item{ylab}{label for y-axes.}

\item{main}{title to be plotted.}

\item{...}{plot arguments (like pch, cex, col,...).}
}
\description{
Plots raw data points of a single profile (e.g. to show measurement gaps).
The topography is considered, i.e., heights are added to the measurement depth.
}
\examples{
data(sinkhole)
plotRawHeight(sinkhole@profiles[[2]])
plotRawHeight(sinkhole@profiles[[2]], sinkhole@profiles[[2]]@xyzData@height)
}
\seealso{
\code{\link{plotRaw}}, \code{\link{RawData-class}}
}

