#' Geo Grids
#'
#' @name grids
#' @docType data
#' @keywords data
#' @description There are now 28 grids available in this package and more online. To view a full list of available grids, see [here](https://raw.githubusercontent.com/hafen/grid-designer/master/grid_list.json). To create and submit your own grid, see [here](https://hafen.github.io/grid-designer/). To see several examples of grids being used to visualize data, see \code{\link{facet_geo}}.
#' @rdname grids
#' @md
NULL

#' @name us_state_grid1
#' @description
#' * **us_state_grid1:** Grid layout for US states (including DC) Image reference [here](https://images7.alphacoders.com/687/687665.jpg).
#' @usage us_state_grid1
#' @rdname grids
#' @md
NULL

#' @name us_state_grid2
#' @description
#' * **us_state_grid2:** Grid layout for US states (including DC) Image reference [here](https://images7.alphacoders.com/687/687665.jpg).
#' @usage us_state_grid2
#' @rdname grids
#' @md
NULL

#' @name eu_grid1
#' @description
#' * **eu_grid1:** Grid layout for the 28 EU Countries Image reference [here](https://ichef.bbci.co.uk/news/660/media/images/70233000/gif/_70233868_eunames.gif).
#' @usage eu_grid1
#' @rdname grids
#' @md
NULL

#' @name aus_grid1
#' @description
#' * **aus_grid1:** Grid layout for the Australian States and Territories. Image reference [here](https://cloud.githubusercontent.com/assets/9496865/26334627/75a729d2-3fa5-11e7-88af-a1dd86b7ddf3.png). Thanks to [jonocarroll](https://github.com/jonocarroll).
#' @usage aus_grid1
#' @rdname grids
#' @md
NULL

#' @name sa_prov_grid1
#' @description
#' * **sa_prov_grid1:** Grid layout for the provinces of South Africa Image reference [here](https://camo.githubusercontent.com/a90b18a1ab0c36200da9b118141b997b3f22638e/687474703a2f2f7777772e6578706c6f7265736f7574686166726963612e6e65742f696d616765732f70726f766d61702e6a7067). Thanks to [jonmcalder](https://github.com/jonmcalder).
#' @usage sa_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name london_boroughs_grid
#' @description
#' * **london_boroughs_grid:** Grid layout for the boroughs of London. Note that the column \code{code_ons} contains the \href{http://geoportal.statistics.gov.uk/datasets/464be6191a434a91a5fa2f52c7433333_0?uiTab=table}{codes} used by UK Office for National Statistics. Image reference [here](https://cloud.githubusercontent.com/assets/13021448/26399784/3133d684-4076-11e7-8eac-1e74d023bf18.jpg). Thanks to [eldenvo](https://github.com/eldenvo).
#' @usage london_boroughs_grid
#' @rdname grids
#' @md
NULL

#' @name nhs_scot_grid
#' @description
#' * **nhs_scot_grid:** Grid layout for a grid of NHS Scotland Health Boards. Note that the column \code{code} contains the \href{http://geoportal.statistics.gov.uk/datasets/61dca36aa33e4aee99bbfa784fa9eb25_0?uiTab=table}{codes} used by UK Office for National Statistics. Image reference [here](https://cloud.githubusercontent.com/assets/24879214/26426113/253658d0-40cf-11e7-88b5-fe5ee7fda44f.png). Thanks to [jsphdms](https://github.com/jsphdms).
#' @usage nhs_scot_grid
#' @rdname grids
#' @md
NULL

#' @name india_grid1
#' @description
#' * **india_grid1:** Grid layout for India states (not including union territories). Image reference [here](https://cloud.githubusercontent.com/assets/11698124/26569168/dd2ca86c-44bd-11e7-9d74-af919522f7b1.jpg). Thanks to [meysubb](https://github.com/meysubb).
#' @usage india_grid1
#' @rdname grids
#' @md
NULL

#' @name india_grid2
#' @description
#' * **india_grid2:** Grid layout for India states (not including union territories). Image reference [here](https://cloud.githubusercontent.com/assets/11698124/26569168/dd2ca86c-44bd-11e7-9d74-af919522f7b1.jpg).
#' @usage india_grid2
#' @rdname grids
#' @md
NULL

#' @name argentina_grid1
#' @description
#' * **argentina_grid1:** Grid for the 23 provinces of Argentina. It includes the Malvinas/Falkland Islands and the Antarctic Territories (these are disputed, but they are included since many researchers might use data from these locations). Image reference [here](https://s-media-cache-ak0.pinimg.com/736x/bf/cb/96/bfcb9654477c127d3b0e0b72d5be65fc.jpg). Thanks to [eliocamp](https://github.com/eliocamp).
#' @usage argentina_grid1
#' @rdname grids
#' @md
NULL

#' @name br_grid1
#' @description
#' * **br_grid1:** Grid for the 27 states of Brazil. Image reference [here](https://camo.githubusercontent.com/477627dce2610f18f1bf3850cd32fca01610656e/687474703a2f2f63656a656475696e66616e74696c2e7062776f726b732e636f6d2f662f313435383034313938342f4d61706142726173696c5369676c61732e676966). Thanks to [italocegatta](https://github.com/italocegatta).
#' @usage br_grid1
#' @rdname grids
#' @md
NULL

#' @name sea_grid1
#' @description
#' * **sea_grid1:** Grid for South East Asian countries. Image reference [here](https://camo.githubusercontent.com/694a275db0e89984f347ce8b49221352416d2c48/68747470733a2f2f7669676e65747465322e77696b69612e6e6f636f6f6b69652e6e65742f757461752f696d616765732f382f38322f536f757468656173745f617369612e6a70672f7265766973696f6e2f6c61746573743f63623d3230313130313230303431383034). Thanks to [jasonjb82](https://github.com/jasonjb82).
#' @usage sea_grid1
#' @rdname grids
#' @md
NULL

#' @name mys_grid1
#' @description
#' * **mys_grid1:** Grid for Malaysian states and territories. Image reference [here](https://camo.githubusercontent.com/cd22848f0b7b53d4ef7afc6d178a0e9579ecf2aa/68747470733a2f2f7777772e6d6170736f66776f726c642e636f6d2f6d616c61797369612f6d6170732f6d616c61797369612d706f6c69746963616c2d6d61702e6a7067). Thanks to [jasonjb82](https://github.com/jasonjb82).
#' @usage mys_grid1
#' @rdname grids
#' @md
NULL

#' @name fr_regions_grid1
#' @description
#' * **fr_regions_grid1:** Land and overseas regions of France. Codes are INSEE codes. Image reference [here](https://camo.githubusercontent.com/b526c357a4c30cdd2e90700c6559381348111377/687474703a2f2f7777772e6361727465736672616e63652e66722f6361727465732f67656f677261706869652f63617274652d726567696f6e732e6a7067). Thanks to [mtmx](https://github.com/mtmx).
#' @usage fr_regions_grid1
#' @rdname grids
#' @md
NULL

#' @name de_states_grid1
#' @description
#' * **de_states_grid1:** Grid for the German states ('Länder') Image reference [here](https://camo.githubusercontent.com/e144ebb2bdd2d82d8a4c34908cd68ab2b2388425/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f642f64332f5374617465735f6f665f4765726d616e792e737667). Thanks to [DominikVogel](https://github.com/DominikVogel).
#' @usage de_states_grid1
#' @rdname grids
#' @md
NULL

#' @name or_counties_grid1
#' @description
#' * **or_counties_grid1:** Grid for Oregon counties. Image reference [here](https://user-images.githubusercontent.com/11638312/27445795-01b77804-5730-11e7-919b-36cde8027706.jpg). Thanks to [aosmith16](https://github.com/aosmith16).
#' @usage or_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name wa_counties_grid1
#' @description
#' * **wa_counties_grid1:** Grid for Washington counties. Image reference [here](http://www.countymapsofwashington.com/aapics/washingstate.gif).
#' @usage wa_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name in_counties_grid1
#' @description
#' * **in_counties_grid1:** Grid for Indiana counties. Image reference [here](https://upload.wikimedia.org/wikipedia/commons/thumb/e/ec/Indiana_county_map.png/640px-Indiana_county_map.png). Thanks to [nateapathy](https://github.com/nateapathy).
#' @usage in_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name in_central_counties_grid1
#' @description
#' * **in_central_counties_grid1:** Grid for central Indiana counties. Image reference [here](https://camo.githubusercontent.com/eb31e821890a0c600f59234fb184335c2bf84423/687474703a2f2f7777772e736176692e6f72672f77702d636f6e74656e742f75706c6f6164732f323031352f30322f6d61702d312e6a7067). Thanks to [nateapathy](https://github.com/nateapathy).
#' @usage in_central_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name se_counties_grid1
#' @description
#' * **se_counties_grid1:** Grid for counties of Sweden. Image reference [here](http://www.worldatlas.com/webimage/countrys/europe/lgcolor/secounties.gif). Thanks to [duleise](https://github.com/duleise).
#' @usage se_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name sf_bay_area_counties_grid1
#' @description
#' * **sf_bay_area_counties_grid1:** Grid of the 9 San Francisco Bay Area counties. Image reference [here](https://user-images.githubusercontent.com/1275592/28043128-53be650a-6585-11e7-920e-4ad9a13bf1a5.png). Thanks to [Eunoia](https://github.com/Eunoia).
#' @usage sf_bay_area_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name ua_region_grid1
#' @description
#' * **ua_region_grid1:** Grid of administrative divisions of Ukraine (24 oblasts, one autonomous region, and two cities). Image reference [here](https://camo.githubusercontent.com/0615706478de63da2c7c3c3b21fe92c6db6a2fee/687474703a2f2f696d61676573312e66616e706f702e636f6d2f696d616765732f696d6167655f75706c6f6164732f556b7261696e69616e2d6d61702d756b7261696e652d313135333138375f3733305f3530352e676966). Thanks to [woldemarg](https://github.com/woldemarg).
#' @usage ua_region_grid1
#' @rdname grids
#' @md
NULL

#' @name mx_state_grid1
#' @description
#' * **mx_state_grid1:** Grid layout for the states of Mexico. Image reference [here](https://user-images.githubusercontent.com/1275592/28044555-ee236b2a-658c-11e7-96e5-3af124ca9619.png). Thanks to [ikashnitsky](https://github.com/ikashnitsky).
#' @usage mx_state_grid1
#' @rdname grids
#' @md
NULL

#' @name mx_state_grid2
#' @description
#' * **mx_state_grid2:** Grid layout for the states of Mexico. Image reference [here](https://user-images.githubusercontent.com/1275592/28044555-ee236b2a-658c-11e7-96e5-3af124ca9619.png). Thanks to [diegovalle](https://github.com/diegovalle).
#' @usage mx_state_grid2
#' @rdname grids
#' @md
NULL

#' @name scotland_local_authority_grid1
#' @description
#' * **scotland_local_authority_grid1:** Grid layout for the local authorities of Scotland. Image reference [here](https://user-images.githubusercontent.com/1275592/28044967-3b508570-658f-11e7-99b5-b1d73c765c2e.png). Thanks to [davidhen](https://github.com/davidhen).
#' @usage scotland_local_authority_grid1
#' @rdname grids
#' @md
NULL

#' @name us_state_grid3
#' @description
#' * **us_state_grid3:** Grid layout for US states (excluding DC) Image reference [here](https://images7.alphacoders.com/687/687665.jpg). Thanks to [ejr248](https://github.com/ejr248).
#' @usage us_state_grid3
#' @rdname grids
#' @md
NULL

#' @name italy_grid1
#' @description
#' * **italy_grid1:** Grid layout for regions of Italy (in collaboration with Stella Cangelosi and Luciana Dalla Valle). Image reference [here](https://user-images.githubusercontent.com/1275592/28291015-8f0abd66-6afd-11e7-9e2a-b4c1d4021c13.png). Thanks to [JulianStander](https://github.com/JulianStander).
#' @usage italy_grid1
#' @rdname grids
#' @md
NULL

#' @name italy_grid2
#' @description
#' * **italy_grid2:** Grid layout for regions of Italy (in collaboration with Stella Cangelosi and Luciana Dalla Valle). Image reference [here](https://user-images.githubusercontent.com/1275592/28291015-8f0abd66-6afd-11e7-9e2a-b4c1d4021c13.png). Thanks to [JulianStander](https://github.com/JulianStander).
#' @usage italy_grid2
#' @rdname grids
#' @md
NULL
