% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps.R
\name{ccri_diff}
\alias{ccri_diff}
\title{Calculate difference map}
\usage{
ccri_diff(x, y, global, geoscale, res = reso(), outdir = tempdir())
}
\arguments{
\item{x}{SpatRaster.}

\item{y}{SpatRaster.}

\item{global}{Logical. \code{TRUE} if global analysis is desired, \code{FALSE} otherwise.
\code{east} and \code{west} are required when \code{TRUE}.}

\item{geoscale}{Numeric vector. \code{x} will be cropped to this extent.}

\item{res}{Numeric. Map resolution. This value is used in aggregation and dis-aggregation operation.
Default is \code{\link[=reso]{reso()}}.}

\item{outdir}{Character. Output directory for saving raster in TIFF format.
Default is \code{\link[=tempdir]{tempdir()}}.}
}
\value{
RiskMap. Contains result in the form of \code{SpatRaster} objects
and file path of the saved maps.
}
\description{
This function produces a map of difference b/w mean and sum indexes in rank of cropland harvested area fraction.
}
\details{
Ideally, the function is tested to yield desired results when
\code{length(which(y[] > 0)) > length(which(x[] > 0))}.
}
