% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geojson_read.R
\name{geojson_read}
\alias{geojson_read}
\title{Read geojson or other formats from a local file or a URL}
\usage{
geojson_read(x, method = "web", parse = FALSE, what = "list", ...)
}
\arguments{
\item{x}{(character) Path to a local file or a URL.}

\item{method}{(character) One of "web" (default) or "local". Matches on partial strings.}

\item{parse}{(logical) To parse geojson to data.frame like structures if possible. 
Default: \code{FALSE}}

\item{what}{(character) What to return. One of "list" or "sp" (for Spatial class). 
Default: "list". If "sp" chosen, forced to \code{method="local"}.}

\item{...}{Additional parameters passed to \code{\link[rgdal]{readOGR}}}
}
\description{
Read geojson or other formats from a local file or a URL
}
\details{
Uses \code{\link{file_to_geojson}} internally to give back geojson, 
and other helper functions when returning spatial classes.

This function supports various geospatial file formats from a URL, as well as local
kml, shp, and geojson file formats.
}
\examples{
\dontrun{
# From a file
file <- system.file("examples", "california.geojson", package = "geojsonio")
out <- geojson_read(file)

# From a URL
url <- "https://raw.githubusercontent.com/glynnbird/usstatesgeojson/master/california.geojson"
geojson_read(url, method = "local")

# Use as.location first if you want
geojson_read(as.location(file))

# use jsonlite to parse to data.frame structures where possible
geojson_read(url, method = "local", parse = TRUE)

# output a SpatialClass object
## read kml
file <- system.file("examples", "norway_maple.kml", package = "geojsonio")
geojson_read(as.location(file), what = "sp")
## read geojson
file <- system.file("examples", "california.geojson", package = "geojsonio")
geojson_read(as.location(file), what = "sp")
## read geojson from a url
url <- "https://raw.githubusercontent.com/glynnbird/usstatesgeojson/master/california.geojson"
geojson_read(url, what = "sp")
## read from a shape file
file <- system.file("examples", "bison.zip", package = "geojsonio")
dir <- tempdir()
unzip(file, exdir = dir)
shpfile <- list.files(dir, pattern = ".shp", full.names = TRUE)
geojson_read(shpfile, what = "sp")

# doesn't work right now
## file <- system.file("examples", "feature_collection.geojson", package = "geojsonio")
## geojson_read(file, what = "sp")
}
}

