% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/successful.R
\name{successful}
\alias{successful}
\alias{running}
\alias{error}
\alias{running}
\alias{error}
\title{Convenience function for GDP process state}
\usage{
successful(.Object, retry)
error(.Object, retry)
running(.Object, retry)

running(.Object, retry = FALSE)

error(.Object, retry = FALSE)
}
\arguments{
\item{.Object}{a \linkS4class{geojob} object or geojob ID (character)}

\item{retry}{logical, attempt to retry again if communication failed with the server}
}
\value{
TRUE/FALSE indicating if process is in the given state (error, processing, successful)
}
\description{
Simple wrapper to check process status
}
\examples{
\dontrun{
job <- geoknife(stencil = c(-89,42), fabric = 'prism')
check(job)

running(job)
error(job)
successful(job)
}

}
\seealso{
\code{\link{check}}
}
\author{
Luke Winslow, Jordan S Read
}
