% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datatables.R
\name{block2prec}
\alias{block2prec}
\title{Aggregate Block Table by Matches}
\usage{
block2prec(block_table, matches, geometry = FALSE)
}
\arguments{
\item{block_table}{Required. Block table output from create_block_table}

\item{matches}{Required. Grouping variable to aggregate up by, typically made with geo_match}

\item{geometry}{Boolean. Whether to keep geometry or not.}
}
\value{
dataframe with length(unique(matches)) rows
}
\description{
Aggregates block table values up to a higher level, normally precincts, hence
the name block2prec.
}
\examples{
set.seed(1)
data(rockland)
rockland$id <- sample(1:2, nrow(rockland), TRUE)
block2prec(rockland, rockland$id)

}
\concept{datatable}
