% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOGeoreferenceable.R
\docType{class}
\name{ISOGeoreferenceable}
\alias{ISOGeoreferenceable}
\title{ISOGeoreferenceable}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Georeferenceable
}
\description{
ISOGeoreferenceable
}
\section{Fields}{

\describe{
\item{\code{controlPointAvailability}}{[\code{\link{logical}}]}

\item{\code{orientationParameterAvailability}}{[\code{\link{logical}}]}

\item{\code{orientationParameterDescription}}{[\code{\link{character}}]}

\item{\code{georeferencedParameters}}{[\code{\link{ISORecord}}]}

\item{\code{parameterCitation}}{[\code{\link{ISOCitation}}]}
}}

\section{Inherited Methods}{

\describe{
 \item{\code{setNumberOfDimensions}}{
   Sets the number of dimensions (value of class \code{integer})
 }
 \item{\code{addDimension(dimension)}}{
   Adds a dimension. Object of class \code{\link{ISODimension}}
 }
 \item{\code{delDimension(dimension)}}{
   Deletes a dimension
 }
 \item{\code{setCellGeometry(cellGeometry)}}{
   Sets the cell geometry. Object of class \code{\link{ISOCellGeometry}} or any value
   from \code{ISOCellGeometry$values()}
 }
 \item{\code{setTransformationParameterAvailability(availability)}}{
   Sets the transformation parameter availability
 }
}
}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOGeoreferenceable}}
 }
 \item{\code{setControlPointAvailability(availability)}}{
   Sets the control point availability. TRUE/FALSE
 }
 \item{\code{setOrientationParameterAvailability(availability)}}{
   Sets the orientation parameter availability. TRUE/FALSE
 }
 \item{\code{setOrientationParameterDescription(description, locales)}}{
   Sets the orientation parameter description. Locale names can be specified
    as \code{list} with the \code{locales} argument.
 }
 \item{\code{setGeoreferencedParameters(record)}}{
   Sets the georeferenced parameter (object of class \code{\link{ISORecord}})
 }
 \item{\code{addParameterCitation(citation)}}{
   Adds a parameter citation, object of class \code{\link{ISOCitation}}
 }
 \item{\code{delParameterCitation(citation)}}{
   Deletes a parameter citation, object of class \code{\link{ISOCitation}}
 }
}
}

\examples{
  md <- ISOGeoreferenceable$new()
  
  #inherited methods from ISOGridSpatialRepresentation
  md$setNumberOfDimensions(1)
  dim1 <- ISODimension$new()
  dim1$setName("row")
  dim1$setSize(100)
  dim1$setResolution(ISOMeasure$new(value=1,uom="m"))
  md$addDimension(dim1)
  md$setCellGeometry("area")
  
  #parameters
  md$setControlPointAvailability(TRUE)
  md$setOrientationParameterAvailability(TRUE)
  md$setOrientationParameterDescription("description")
  md$setGeoreferencedParameters("record")
  ct <- ISOCitation$new()
  ct$setTitle("citation")
  md$addParameterCitation(ct)
  
  xml <- md$encode()

}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{georeferenceable}
\keyword{grid}
\keyword{representation}
\keyword{spatial}
