% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualise.R
\name{visualise}
\alias{visualise}
\title{Visualise geometric objects}
\usage{
visualise(
  ...,
  window = NULL,
  trace = FALSE,
  new = TRUE,
  clip = TRUE,
  theme = gtTheme
)
}
\arguments{
\item{...}{objects to plot and optional graphical parameters.}

\item{window}{[\code{data.frame(1)}]\cr two opposing corners of a rectangle
to which the plot is limited.}

\item{trace}{[\code{logical(1)}]\cr Print the provenance information of the
geometric object (if available) (\code{TRUE}), or simply plot the object
(\code{FALSE}, default).}

\item{new}{[\code{logical(1)}]\cr force a new plot (\code{TRUE}, default).}

\item{clip}{[\code{logical(1)}]\cr clip the plot by the plot box
(\code{TRUE}, default), or plot also objects that go beyond the plot box.}

\item{theme}{[\code{list(7)}]\cr the theme from which to take graphical
parameters; see \code{\link{setTheme}} for details.}
}
\value{
Returns invisibly an object of class \code{recordedplot}, see
  \code{\link{recordPlot}} for details (and warnings).
}
\description{
Visualise geometric objects
}
\examples{
# make an empty plot
visualise()
visualise(window = getExtent(gtRasters$continuous))

coords <- data.frame(x = c(30, 60, 60, 40),
                     y = c(40, 40, 60, 70),
                     fid = 1)
(aGeom <- gs_polygon(anchor = coords))
visualise(aGeom)

win <- data.frame(x = c(0, 80),
                  y = c(0, 80))
withWindow <- setWindow(x = aGeom, to = win)
visualise(expanded = withWindow)

(aRaster <-  gtRasters$categorical)

# plot several objects together
visualise(aRaster, aGeom)

# give names
visualise(`a raster` = aRaster, `a geom` = aGeom)

# use graphical parameters ...
visualise(aGeom, linecol = "green")

# ... or a theme
visualise(aRaster, theme = setTheme(title = list(plot = FALSE)))

}
