% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setHistory.R
\docType{methods}
\name{setHistory}
\alias{setHistory}
\alias{setHistory,ANY-method}
\alias{setHistory,geom-method}
\alias{setHistory,RasterLayer-method}
\title{Set additional entries to the history of an object}
\usage{
\S4method{setHistory}{ANY}(x)

\S4method{setHistory}{geom}(x, history = NULL)

\S4method{setHistory}{RasterLayer}(x, history = NULL)
}
\arguments{
\item{x}{the object for which to set the coordinate reference system.}

\item{history}{[\code{list(1)}]\cr the history to set for this object.}
}
\value{
The object \code{x} where the history slot has been updated.
}
\description{
Set additional entries to the history of an object
}
\details{
Both, objects of class \code{geom} and \code{Raster*} have the slot
  \code{@history}, which contains the provenance of that object. With
  \code{setHistory}, that provenance can be updated, based on the
  modification the object has been exposed to. This happens automatically for
  all geometry operations that come with \code{geometr}.
}
\seealso{
Other setters: 
\code{\link{setCRS}()},
\code{\link{setFeatures}()},
\code{\link{setGroups}()},
\code{\link{setWindow}()}
}
\concept{setters}
