% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm.prcomp.R
\name{gm.prcomp}
\alias{gm.prcomp}
\title{Principal components analysis of shape data}
\usage{
gm.prcomp(A, phy = NULL, ...)
}
\arguments{
\item{A}{A 3D array (p x k x n) containing Procrustes shape variables for a set of aligned specimens}

\item{phy}{An optional phylogenetic tree of class phylo}

\item{...}{Other arguments passed to \code{\link{scale}}}
}
\value{
An object of class "gm.prcomp" contains a list of results for each of the PCA approaches implemented.
Each of these lists includes the following components:
\item{x}{Principal component scores for all specimens.}
\item{anc.x}{Principal component scores for the ancestors on the phylogeny.}
\item{d}{The singular values of the decomposed VCV matrix.}
\item{rotation}{The matrix of variable loadings, i.e. the eigenvectors of the decomposed matrix.}
\item{shapes}{A list with the shape coordinates of the extreme ends of all PC axes.}
\item{ancestors}{The matrix of estimated ancestral shapes, if a phylogeny is used.}
}
\description{
Function performs PCA on Procrustes shape coordinates
}
\details{
The function performs a principal components analysis of shape variation.
It also allows a phylomorphospace approach, where the user can provide a phylogeny
and obtain a graph with estimated ancestral shape values and the tree projected
into PCA space.

PLOTTING: Contrary to previous geomorph implementations, gm.prcomp does not produce plots. 
For plotting options of gm.prcomp class objects combine \code{\link{plot.gm.prcomp}} and 
\code{\link{picknplot.shape}} following the examples below. Note that trying to plot the full result
of gm.prcomp will give an error. Choose a specific PCA method to be plotted, by pointing to one of the 
components of the list returned by gm.prcomp.
}
\examples{
 data(plethspecies) 
 Y.gpa <- gpagen(plethspecies$land)    #GPA-alignment
 
 ### PCA 
 pleth.raw <- gm.prcomp(Y.gpa$coords)
 summary(pleth.raw)
 
 ### PCA with phylogeny (result is same as above, but with additional components)
 pleth.phylo <- gm.prcomp(Y.gpa$coords, phy = plethspecies$phy)
 summary(pleth.phylo)
 
 #### Plotting
 plot(pleth.raw)
 gps <- as.factor(c(rep("gp1", 5), rep("gp2", 4))) # Two random groups
 par(mar=c(2, 2, 2, 2))
 plot(pleth.raw, pch=22, cex = 1.5, bg = gps) # Modify options as desired
 #  Add things as desired using standard R plotting
 text(par()$usr[1], 0.1*par()$usr[3], labels = "PC1 - 45.64\%", pos = 4, font = 2)
 text(0, 0.95*par()$usr[4], labels = "PC2 - 18.80\%", pos = 4, font = 2)
 legend("topleft", pch=22, pt.bg = unique(gps), legend = levels(gps))
 
 ### Phylomorphospace plot
 plot(pleth.phylo, pch=21, bg=1:nrow(pleth.phylo$x), phylo = TRUE,
      phylo.par = list(edge.color="grey", node.cex=0)); title(main="phylomorphospace")
 text(pleth.phylo$x, labels = labels(pleth.phylo$x)[[1]],
      pos = 2, font = 4) 
 text(pleth.phylo$anc.x, labels = 1:nrow(pleth.phylo$anc.x),
      adj = c(-0.1, -0.1), font = 2) 
 
 ### Visualize shape variation using picknplot.shape Because picknplot requires 
 ### user decisions, the following example
 ### is not run (but can be with removal of #).
 ### For detailed options, see the picknplot help file
 # picknplot.shape(plot(pleth.phylo))
 

}
\seealso{
\code{\link{plot.gm.prcomp}}

\code{\link{picknplot.shape}}
}
\author{
Antigoni Kaliontzopoulou, Michael Collyer & Dean Adams
}
\keyword{visualization}
