% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geos-plot.R
\name{plot.geos_geometry}
\alias{plot.geos_geometry}
\title{Plot GEOS geometries}
\usage{
\method{plot}{geos_geometry}(
  x,
  ...,
  asp = 1,
  bbox = NULL,
  xlab = "",
  ylab = "",
  rule = "evenodd",
  add = FALSE
)
}
\arguments{
\item{x}{A \link[=as_geos_geometry]{GEOS geometry vector}}

\item{...}{Passed to plotting functions for features: \code{\link[graphics:points]{graphics::points()}}
for point and multipoint geometries, \code{\link[graphics:lines]{graphics::lines()}} for linestring
and multilinestring geometries, and \code{\link[graphics:polypath]{graphics::polypath()}} for polygon
and multipolygon geometries.}

\item{asp}{Passed to \code{\link[graphics:plot.default]{graphics::plot()}}}

\item{bbox}{The limits of the plot in the form returned by \code{\link[wkutils:wkb_ranges]{wkt_ranges()}}.}

\item{xlab}{Passed to \code{\link[graphics:plot.default]{graphics::plot()}}}

\item{ylab}{Passed to \code{\link[graphics:plot.default]{graphics::plot()}}}

\item{rule}{The rule to use for filling polygons (see \code{\link[graphics:polypath]{graphics::polypath()}})}

\item{add}{Should a new plot be created, or should \code{x} be added to the
existing plot?}
}
\value{
The input, invisibly
}
\description{
Plot GEOS geometries
}
\examples{
if (requireNamespace("wkutils")) {
  plot(as_geos_geometry("LINESTRING (0 0, 1 1)"))
  plot(as_geos_geometry("POINT (0.5 0.4)"), add = TRUE)
}

}
