% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geos-binary-atomic.R
\name{geos_relate}
\alias{geos_relate}
\alias{geos_relate_pattern}
\alias{geos_relate_pattern_match}
\alias{geos_relate_pattern_create}
\title{Dimensionally extended 9 intersection model}
\usage{
geos_relate(geom1, geom2, boundary_node_rule = "mod2")

geos_relate_pattern(geom1, geom2, pattern, boundary_node_rule = "mod2")

geos_relate_pattern_match(match, pattern)

geos_relate_pattern_create(
  II = "*",
  IB = "*",
  IE = "*",
  BI = "*",
  BB = "*",
  BE = "*",
  EI = "*",
  EB = "*",
  EE = "*"
)
}
\arguments{
\item{geom1}{\link[=as_geos_geometry]{GEOS geometry vectors},
recycled to a common length.}

\item{geom2}{\link[=as_geos_geometry]{GEOS geometry vectors},
recycled to a common length.}

\item{boundary_node_rule}{One of "mod2", "endpoint", "multivalent_endpoint",
or "monovalent_endpoint".}

\item{pattern, match}{A character vector representing the match}

\item{II, IB, IE, BI, BB, BE, EI, EB, EE}{One of "0", "1", "2", "T", "F", or "*"
describing the dimension of the intersection between the interior (I),
boundary (B), and exterior (E).}
}
\description{
See the \href{https://en.wikipedia.org/wiki/DE-9IM}{Wikipedia entry on DE-9IM}
for how to interpret \code{pattern}, \code{match}, and the result of \code{\link[=geos_relate]{geos_relate()}}
and/or \code{\link[=geos_relate_pattern_create]{geos_relate_pattern_create()}}.
}
\examples{
geos_relate_pattern_match("FF*FF1***", c(NA, "FF*FF****", "FF*FF***F"))
geos_relate("POINT (0 0)", "POINT (0 0)")
geos_relate_pattern("POINT (0 0)", "POINT (0 0)", "T********")
geos_relate_pattern_create(II = "T")

}
