% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSShapefileDirectoryDataStore.R
\docType{class}
\name{GSShapefileDirectoryDataStore}
\alias{GSShapefileDirectoryDataStore}
\title{Geoserver REST API ShapeFileDirectoryDataStore}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer Shapefile directory dataStore
}
\description{
Geoserver REST API ShapeFileDirectoryDataStore
}
\section{Methods}{

\describe{
   \item{\code{new(xml, dataStore, description, enabled, url)}}{
     Instantiates a GSShapefileDirectoryDataStore object
   }
   \item{\code{setUrl(url)}}{
     Set the spatial files data URL
   }
   \item{\code{setCharset(charset)}}{
     Set the charset used for DBF file. Default value is 'ISO-8859-1'
   }
   \item{\code{setCreateSpatialIndex(create)}}{
     Set the 'Create Spatial Index' option. Default is TRUE
   }
   \item{\code{setMemoryMappedBuffer(buffer)}}{
     Set the 'Memory Mapped Buffer' option. Default is TRUE
   }
   \item{\code{CacheReuseMemoryMaps(maps)}}{
     Set the 'Cache & Reuse Memory Maps' option. Default is TRUE
   }
   \item{\code{setDefautConnectionParameters()}}{
     Set the defaut connection paramaters
   }
}
}

\examples{
GSShapefileDirectoryDataStore$new(dataStore="ds", description = "des",
                         enabled = TRUE, url = "file://data")

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{DataStore}
\keyword{ESRI}
\keyword{api}
\keyword{directory}
\keyword{geoserver}
\keyword{rest}
\keyword{shapefile}
