% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSShapefileDirectoryDataStore.R
\docType{class}
\name{GSShapefileDirectoryDataStore}
\alias{GSShapefileDirectoryDataStore}
\title{Geoserver REST API ShapeFileDirectoryDataStore}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer Shapefile directory dataStore
}
\description{
Geoserver REST API ShapeFileDirectoryDataStore

Geoserver REST API ShapeFileDirectoryDataStore
}
\examples{
GSShapefileDirectoryDataStore$new(name = "ds", description = "des",
                         enabled = TRUE, url = "file://data")

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{DataStore}
\keyword{ESRI}
\keyword{api}
\keyword{directory}
\keyword{geoserver}
\keyword{rest}
\keyword{shapefile}
\section{Super classes}{
\code{\link[geosapi:GSRESTResource]{geosapi::GSRESTResource}} -> \code{\link[geosapi:GSAbstractStore]{geosapi::GSAbstractStore}} -> \code{\link[geosapi:GSAbstractDataStore]{geosapi::GSAbstractDataStore}} -> \code{\link[geosapi:GSShapefileDataStore]{geosapi::GSShapefileDataStore}} -> \code{GSShapefileDirectoryDataStore}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSShapefileDirectoryDataStore-new}{\code{GSShapefileDirectoryDataStore$new()}}
\item \href{#method-GSShapefileDirectoryDataStore-setUrl}{\code{GSShapefileDirectoryDataStore$setUrl()}}
\item \href{#method-GSShapefileDirectoryDataStore-setCharset}{\code{GSShapefileDirectoryDataStore$setCharset()}}
\item \href{#method-GSShapefileDirectoryDataStore-setCreateSpatialIndex}{\code{GSShapefileDirectoryDataStore$setCreateSpatialIndex()}}
\item \href{#method-GSShapefileDirectoryDataStore-setMemoryMappedBuffer}{\code{GSShapefileDirectoryDataStore$setMemoryMappedBuffer()}}
\item \href{#method-GSShapefileDirectoryDataStore-setCacheReuseMemoryMaps}{\code{GSShapefileDirectoryDataStore$setCacheReuseMemoryMaps()}}
\item \href{#method-GSShapefileDirectoryDataStore-setDefautConnectionParameters}{\code{GSShapefileDirectoryDataStore$setDefautConnectionParameters()}}
\item \href{#method-GSShapefileDirectoryDataStore-clone}{\code{GSShapefileDirectoryDataStore$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="encode"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-encode'><code>geosapi::GSRESTResource$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractStore" data-id="setDescription"><a href='../../geosapi/html/GSAbstractStore.html#method-GSAbstractStore-setDescription'><code>geosapi::GSAbstractStore$setDescription()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractStore" data-id="setEnabled"><a href='../../geosapi/html/GSAbstractStore.html#method-GSAbstractStore-setEnabled'><code>geosapi::GSAbstractStore$setEnabled()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractStore" data-id="setType"><a href='../../geosapi/html/GSAbstractStore.html#method-GSAbstractStore-setType'><code>geosapi::GSAbstractStore$setType()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDataStore" data-id="addConnectionParameter"><a href='../../geosapi/html/GSAbstractDataStore.html#method-GSAbstractDataStore-addConnectionParameter'><code>geosapi::GSAbstractDataStore$addConnectionParameter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDataStore" data-id="decode"><a href='../../geosapi/html/GSAbstractDataStore.html#method-GSAbstractDataStore-decode'><code>geosapi::GSAbstractDataStore$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDataStore" data-id="delConnectionParameter"><a href='../../geosapi/html/GSAbstractDataStore.html#method-GSAbstractDataStore-delConnectionParameter'><code>geosapi::GSAbstractDataStore$delConnectionParameter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDataStore" data-id="setConnectionParameter"><a href='../../geosapi/html/GSAbstractDataStore.html#method-GSAbstractDataStore-setConnectionParameter'><code>geosapi::GSAbstractDataStore$setConnectionParameter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSAbstractDataStore" data-id="setConnectionParameters"><a href='../../geosapi/html/GSAbstractDataStore.html#method-GSAbstractDataStore-setConnectionParameters'><code>geosapi::GSAbstractDataStore$setConnectionParameters()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSShapefileDirectoryDataStore-new"></a>}}
\if{latex}{\out{\hypertarget{method-GSShapefileDirectoryDataStore-new}{}}}
\subsection{Method \code{new()}}{
initializes a shapefile directory data store
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSShapefileDirectoryDataStore$new(
  xml = NULL,
  name = NULL,
  description = "",
  enabled = TRUE,
  url
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{an object of class \link{XMLInternalNode-class} to create object from XML}

\item{\code{name}}{coverage store name}

\item{\code{description}}{coverage store description}

\item{\code{enabled}}{whether the store should be enabled or not. Default is \code{TRUE}}

\item{\code{url}}{url}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSShapefileDirectoryDataStore-setUrl"></a>}}
\if{latex}{\out{\hypertarget{method-GSShapefileDirectoryDataStore-setUrl}{}}}
\subsection{Method \code{setUrl()}}{
Set the spatial files data URL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSShapefileDirectoryDataStore$setUrl(url)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{url}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSShapefileDirectoryDataStore-setCharset"></a>}}
\if{latex}{\out{\hypertarget{method-GSShapefileDirectoryDataStore-setCharset}{}}}
\subsection{Method \code{setCharset()}}{
Set the charset used for DBF file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSShapefileDirectoryDataStore$setCharset(charset = "ISO-8859-1")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{charset}}{charset. Default value is 'ISO-8859-1'}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSShapefileDirectoryDataStore-setCreateSpatialIndex"></a>}}
\if{latex}{\out{\hypertarget{method-GSShapefileDirectoryDataStore-setCreateSpatialIndex}{}}}
\subsection{Method \code{setCreateSpatialIndex()}}{
Set the 'Create Spatial Index' option
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSShapefileDirectoryDataStore$setCreateSpatialIndex(create = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{create}}{create. Default is \code{TRUE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSShapefileDirectoryDataStore-setMemoryMappedBuffer"></a>}}
\if{latex}{\out{\hypertarget{method-GSShapefileDirectoryDataStore-setMemoryMappedBuffer}{}}}
\subsection{Method \code{setMemoryMappedBuffer()}}{
Set the 'Memory Mapped Buffer' option
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSShapefileDirectoryDataStore$setMemoryMappedBuffer(buffer = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{buffer}}{buffer. Default is \code{FALSE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSShapefileDirectoryDataStore-setCacheReuseMemoryMaps"></a>}}
\if{latex}{\out{\hypertarget{method-GSShapefileDirectoryDataStore-setCacheReuseMemoryMaps}{}}}
\subsection{Method \code{setCacheReuseMemoryMaps()}}{
Set the 'Cache & Reuse Memory Maps' option.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSShapefileDirectoryDataStore$setCacheReuseMemoryMaps(maps = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{maps}}{maps. Default is \code{TRUE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSShapefileDirectoryDataStore-setDefautConnectionParameters"></a>}}
\if{latex}{\out{\hypertarget{method-GSShapefileDirectoryDataStore-setDefautConnectionParameters}{}}}
\subsection{Method \code{setDefautConnectionParameters()}}{
Set default connection parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSShapefileDirectoryDataStore$setDefautConnectionParameters()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSShapefileDirectoryDataStore-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSShapefileDirectoryDataStore-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSShapefileDirectoryDataStore$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
