% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.sf.points.R
\name{get.geotop.points}
\alias{get.geotop.points}
\title{Get a \code{\link{sf}} object for Meteorological Stations or Control Points in a GEOtop simulation}
\usage{
get.geotop.points(
  prefix = c("MeteoStation", "CoordinatePoint"),
  suffixes = c("Code", "Elevation", "Source"),
  coord_suffixes = list(MeteoStation = c("CoordinateX", "CoordinateY"), CoordinatePoint =
    c("X", "Y")),
  wpath,
  ...,
  vector_sep = ","
)
}
\arguments{
\item{prefix}{keyword prefix}

\item{suffixes}{keyword suffixes}

\item{coord_suffixes}{coordinate keyword suffixes. Default is \code{c("PointX","PointY")}}

\item{wpath}{GEOtop simulation path}

\item{vector_sep, ...}{further arguments for \code{\link{get.geotop.inpts.keyword.value}}}
}
\description{
Get a \code{\link{sf}} object for Meteorological Stations or Control Points in a GEOtop simulation
}
\examples{

\donttest{
###See simulation template: "https://github.com/ecor/geotopbricks_doc/tree/master/template/sumava"
wpath <- "https://raw.githubusercontent.com/ecor/geotopbricks_doc/master/template/sumava/"
## system.file("template/sumava",package="geotopbricks") 
out <- get.geotop.points(wpath=wpath)
out <- get.geotop.points(prefix="CoordinatePoint",suffix=c("Code","Source"),wpath=wpath)
out <- get.geotop.points(prefix="MeteoStation",suffix=c("Code","Source"),wpath=wpath)

}
}
