% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_constructors.R
\name{GGamma}
\alias{GGamma}
\title{Generalised Gamma Curve constructor function}
\usage{
GGamma(theta, eta, rho)
}
\arguments{
\item{theta}{Scale parameter for Generalised Gamma distribution.}

\item{eta}{Shape parameter for Generalised Gamma distribution.}

\item{rho}{Family parameter for Generalised Gamma distribution.}
}
\description{
This creates a Curve object for a Generalised Gamma distribution.\cr
Curve objects contain all necessary information to describe a distribution, including functions and parameters describing it.\cr
See Details for information on parameterisation.
}
\details{
The Generalised Gamma distribution has parameterisation:\cr
f(x) = (rho x^((rho eta)-1) e^(-(x/theta)^rho) theta^(-rho eta) )/Gamma(eta)\cr
F(x) = LPGamma(eta,(x/theta)^rho)/Gamma(eta)\cr
where Gamma is the gamma function, and LPGamma is the lower partial gamma function\cr
Please note that there is a restriction when simulating that eta must be greater than 1. No such restriction applies for analytical calculations.\cr
}
\examples{
GGamma(theta=20,eta=2,rho=0.7)
}
\references{
Tadikamalla PR, Random Sampling from the Generalized Gamma Distribution. Computing, 1979, 23(2), 199-203.
}
\author{
Jasmin Ruehl
}
