% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_CRU_stack.R
\name{create_CRU_stack}
\alias{create_CRU_stack}
\alias{create_cru_stack}
\title{Create a list of terra rast objects of CRU CL v. 2.0 climatology elements from local disk files}
\source{
\describe{
\item{pre}{\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/grid_10min_pre.dat.gz}}
\item{rd0}{\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/grid_10min_rd0.dat.gz}}
\item{tmp}{\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/grid_10min_tmp.dat.gz}}
\item{dtr}{\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/grid_10min_dtr.dat.gz}}
\item{reh}{\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/grid_10min_reh.dat.gz}}
\item{sunp}{\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/grid_10min_sunp.dat.gz}}
\item{frs}{\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/grid_10min_frs.dat.gz}}
\item{wnd}{\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/grid_10min_wnd.dat.gz}, areas originally including Antarctica are removed.}
\item{elv}{\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/grid_10min_elv.dat.gz}, values are converted from kilometres to metres.}
}
This package crops all spatial outputs to an extent of ymin = -60, ymax = 85,
xmin = -180, xmax = 180.
}
\usage{
create_CRU_stack(
  pre = FALSE,
  pre_cv = FALSE,
  rd0 = FALSE,
  tmp = FALSE,
  dtr = FALSE,
  reh = FALSE,
  tmn = FALSE,
  tmx = FALSE,
  sunp = FALSE,
  frs = FALSE,
  wnd = FALSE,
  elv = FALSE,
  dsn
)

create_cru_stack(
  pre = FALSE,
  pre_cv = FALSE,
  rd0 = FALSE,
  tmp = FALSE,
  dtr = FALSE,
  reh = FALSE,
  tmn = FALSE,
  tmx = FALSE,
  sunp = FALSE,
  frs = FALSE,
  wnd = FALSE,
  elv = FALSE,
  dsn
)
}
\arguments{
\item{pre}{Loads precipitation (millimetres/month) from server and
returns in the data frame, \code{TRUE}. Defaults to \code{FALSE}.}

\item{pre_cv}{Loads cv of precipitation (percent) from server and
returns in the data frame, \code{TRUE}. Defaults to \code{FALSE}. NOTE. Setting this
to \code{TRUE} will always results in \strong{pre} being set to \code{TRUE} and
returned as well.}

\item{rd0}{Loads wet-days (number days with >0.1 millimetres rain per
month) and returns in the data frame, \code{TRUE}. Defaults to \code{FALSE}.}

\item{tmp}{Loads temperature (degrees Celsius) and returns it in the
data frame, \code{TRUE}. Defaults to \code{FALSE}.}

\item{dtr}{Loads mean diurnal temperature range (degrees Celsius)
and returns it in the data frame, \code{TRUE}. Defaults to \code{FALSE}.}

\item{reh}{Loads relative humidity and returns it in the data frame, \code{TRUE}.
Defaults to \code{FALSE}.}

\item{tmn}{Calculate minimum temperature values (degrees Celsius)
and returns it in the data frame, \code{TRUE}. Defaults to \code{FALSE}.}

\item{tmx}{Calculate maximum temperature (degrees Celsius) and
return it in the data frame, \code{TRUE}. Defaults to \code{FALSE}.}

\item{sunp}{Loads sunshine, percent of maximum possible (percent of
day length) and returns it in the data frame, \code{TRUE}. Defaults to \code{FALSE}.}

\item{frs}{Loads ground-frost records (number of days with ground-
frost per month) and returns it in the data frame, \code{TRUE}. Defaults to
\code{FALSE}.}

\item{wnd}{Load 10 m wind speed (metres/second) and returns it in the
data frame, \code{TRUE}. Defaults to \code{FALSE}.}

\item{elv}{Loads elevation (converted to metres) and returns it in
the data frame, \code{TRUE}. Defaults to \code{FALSE}.}

\item{dsn}{Local file path where \acronym{CRU} \acronym{CL} v.2.0 .dat.gz
files are located.}
}
\value{
A \link[base:list]{base::list} of \link[terra:rast]{terra::rast} objects of \acronym{CRU}
\acronym{CL} v. 2.0 climatology elements.
}
\description{
Automates importing \acronym{CRU} \acronym{CL} v.2.0 climatology
data and creates a \CRANpkg{terra} \link[terra:rast]{terra::rast} object of the
data.  If requested, minimum and maximum temperature may also be
automatically calculated as described in the data
\href{https://crudata.uea.ac.uk/cru/data/hrg/tmc/readme.txt}{readme.txt} file.
Data may be cached for later use by this function, saving time downloading
files in future using this function.  This function can be useful if you
have network connection issues that mean automated downloading of the files
using \R does not work properly or you have cached the files locally for
your own future use.
}
\section{Nomenclature and Units}{

\describe{
\item{pre}{precipitation (millimetres/month)}
\describe{
\item{cv}{cv of precipitation (percent)}
}
\item{rd0}{wet-days (number days with >0.1 millimetres rain per month)}
\item{tmp}{mean temperature (degrees Celsius)}
\item{dtr}{mean diurnal temperature range (degrees Celsius)}
\item{reh}{relative humidity (percent)}
\item{sunp}{sunshine (percent of maximum possible (percent of day length))}
\item{frs}{ground-frost (number of days with ground-frost per month)}
\item{wnd}{10 metre windspeed (metres/second)}
\item{elv}{elevation (automatically converted to metres)}
}
For more information see the description of the data provided by
\acronym{CRU}, \url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/readme.txt}
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

download.file(
  url = "https://crudata.uea.ac.uk/cru/data/hrg/tmc/grid_10min_tmp.dat.gz",
  destfile = file.path(tempdir(), "grid_10min_tmp.dat.gz")
)

CRU_tmp <- create_CRU_stack(tmp = TRUE, dsn = tempdir())

CRU_tmp
\dontshow{\}) # examplesIf}
}
\references{
New, Mark, et al. "A high-resolution data set of surface climate
over global land areas." Climate research 21.1 (2002): 1-25.
\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/new_et_al_10minute_climate_CR.pdf}
}
\seealso{
\link{get_CRU_stack}.
}
\author{
Adam H. Sparks, \email{adamhsparks@gmail.com}
}
