% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSWATwunderForecast.R
\name{getSWATwunderForecast}
\alias{getSWATwunderForecast}
\title{Gets met data from the wundergorund 10 day forecast and outputs SWAT IO format meteorological input files}
\usage{
getSWATwunderForecast(centroids, outDir = getwd(), apiKey)
}
\arguments{
\item{centroids}{- data.frame object or location of csv file with two columns, the first being lattitude and second being longidute in decimal degrees. These should be the centroids of the swat model subbasins and are the locations of the ouput met data.}

\item{outDir}{- Directory where ouput files will be saved.}

\item{apiKey}{- String input of your freely available api key from wunderground.com. See https://www.wunderground.com/weather/api/d/pricing.html for more details. Select the ANVIL version of the developer plan, record the resulting key and use it in this function.}
}
\value{
returns wudnerground 10 day forecast met data in swat IO format
}
\description{
Gets met data from the wundergorund 10 day forecast and outputs SWAT IO format meteorological input files
}
\examples{
\dontrun{
centroids = data.frame(lat = 38, lon = 79)
outDir = "test"
getSWATwunderForecast(centroids=centroids, outDir=outDir)
}
}

